/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.sleep;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class SleepOnGround<E extends LivingEntity>
extends Behavior<E> {
    private static final long COOLDOWN_AFTER_BEING_WOKEN = 100L;
    private static final double MIN_Y_DIST_FROM_SLEEPING_POS = 0.0;
    private static final double MAX_DIST_FROM_SLEEPING_POS = 1.14;
    private final Predicate<E> canSleep;
    private final Consumer<E> onSleepTick;

    public SleepOnGround(Predicate<E> canSleep, Consumer<E> onSleepTick) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26329_, (Object)MemoryStatus.REGISTERED));
        this.canSleep = canSleep;
        this.onSleepTick = onSleepTick;
    }

    protected boolean m_6114_(ServerLevel level, E entity) {
        long ticksSinceLastWoken;
        if (entity.m_20159_()) {
            return false;
        }
        Optional lastWoken = entity.m_6274_().m_21952_(MemoryModuleType.f_26329_);
        if (lastWoken.isPresent() && (ticksSinceLastWoken = level.m_46467_() - (Long)lastWoken.get()) > 0L && ticksSinceLastWoken < 100L) {
            return this.canSleep.test(entity);
        }
        return this.canSleep.test(entity);
    }

    protected void m_6735_(ServerLevel level, E entity, long gameTime) {
        GenericAi.goToSleep(entity);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    protected boolean m_6737_(ServerLevel level, E entity, long gameTime) {
        Optional optionalSleepingPos = entity.m_21257_();
        if (optionalSleepingPos.isEmpty()) {
            return false;
        }
        BlockPos sleepingPos = (BlockPos)optionalSleepingPos.get();
        return this.canSleep.test(entity) && entity.m_6274_().m_21954_(Activity.f_37982_) && sleepingPos.m_203195_((Position)entity.m_20182_(), 1.14);
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected void m_6725_(ServerLevel level, E entity, long gameTime) {
        this.onSleepTick.accept(entity);
    }

    protected void m_6732_(ServerLevel level, E entity, long gameTime) {
        if (entity.m_5803_()) {
            GenericAi.wakeUp(entity);
        }
    }
}

