/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.sleep;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class MoveToNonSkySeeingSpot
extends Behavior<LivingEntity> {
    private final float speedModifier;

    public MoveToNonSkySeeingSpot(float speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
    }

    protected boolean m_6114_(ServerLevel level, LivingEntity entity) {
        return level.m_45527_(entity.m_20183_());
    }

    protected void m_6735_(ServerLevel level, LivingEntity entity, long gameTime) {
        Optional<Vec3> shelterPosition = Optional.ofNullable(this.getShelterPosition(level, entity));
        if (shelterPosition.isPresent()) {
            entity.m_6274_().m_21886_(MemoryModuleType.f_26370_, shelterPosition.map(vec3 -> new WalkTarget(vec3, this.speedModifier, 0)));
        }
    }

    @Nullable
    private Vec3 getShelterPosition(ServerLevel level, LivingEntity entity) {
        RandomSource random = entity.m_217043_();
        BlockPos blockPosition = entity.m_20183_();
        for (int i = 0; i < 10; ++i) {
            BlockPos offset = blockPosition.m_7918_(random.m_188503_(20) - 10, random.m_188503_(6) - 3, random.m_188503_(20) - 10);
            if (!MoveToNonSkySeeingSpot.hasBlocksAbove((Level)level, entity, offset)) continue;
            return Vec3.m_82539_((Vec3i)offset);
        }
        return null;
    }

    public static boolean hasBlocksAbove(Level level, LivingEntity entity, BlockPos blockPos) {
        return !level.m_45527_(blockPos) && (double)level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > entity.m_20186_();
    }
}

