/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.pet;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.behavior.TargetBehavior;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraftforge.common.util.TriPredicate;

public class OwnerHurtByTarget<M extends Mob>
extends TargetBehavior<M> {
    private LivingEntity ownerLastHurtBy;
    private int timestamp;
    private final Predicate<M> canCheck;
    private final TriPredicate<M, LivingEntity, LivingEntity> wantsToAttack;
    private LivingEntity owner;

    public OwnerHurtByTarget() {
        this((M mob) -> true, (mob, target, owner) -> true);
    }

    public OwnerHurtByTarget(TriPredicate<M, LivingEntity, LivingEntity> wantsToAttack) {
        this((M mob) -> true, wantsToAttack);
    }

    public OwnerHurtByTarget(Predicate<M> canCheck, TriPredicate<M, LivingEntity, LivingEntity> wantsToAttack) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), false);
        this.canCheck = canCheck;
        this.wantsToAttack = wantsToAttack;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, M tamable) {
        if (this.canCheck.test(tamable)) {
            Optional<LivingEntity> owner = AiUtil.getOwner((OwnableEntity)tamable);
            if (owner.isEmpty()) {
                return false;
            }
            this.owner = owner.get();
            this.ownerLastHurtBy = this.owner.m_21188_();
            int lastHurtByMobTimestamp = this.owner.m_21213_();
            return lastHurtByMobTimestamp != this.timestamp && this.canAttack(tamable, this.ownerLastHurtBy, TargetingConditions.f_26872_) && this.wantsToAttack.test(tamable, (Object)this.ownerLastHurtBy, (Object)this.owner);
        }
        return false;
    }

    @Override
    protected void start(ServerLevel level, M tamable, long gameTime) {
        StartAttacking.m_24213_(tamable, (LivingEntity)this.ownerLastHurtBy);
        this.timestamp = this.owner.m_21213_();
        super.start(level, tamable, gameTime);
    }
}

