/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.pet;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.compat.CompatUtil;
import com.infamous.all_bark_all_bite.common.compat.DICompat;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class FollowOwner<E extends PathfinderMob>
extends Behavior<E> {
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final Predicate<E> dontFollowIf;
    private final Function<E, Optional<LivingEntity>> entityGetter;
    private final float speedModifier;
    private final int closeEnough;
    private final ToIntFunction<E> tooFar;
    private int calculatePathCounter;
    private float oldWaterCost;
    private final boolean canFly;

    public FollowOwner(Function<E, Optional<LivingEntity>> entityGetter, float speedModifier, int closeEnough, int tooFar) {
        this(mob -> false, entityGetter, speedModifier, closeEnough, value -> tooFar);
    }

    public FollowOwner(Predicate<E> dontFollowIf, Function<E, Optional<LivingEntity>> entityGetter, float speedModifier, int closeEnough, ToIntFunction<E> tooFar) {
        this(dontFollowIf, entityGetter, speedModifier, closeEnough, tooFar, false);
    }

    public FollowOwner(Predicate<E> dontFollowIf, Function<E, Optional<LivingEntity>> entityGetter, float speedModifier, int closeEnough, ToIntFunction<E> tooFar, boolean canFly) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get()), (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED));
        this.dontFollowIf = dontFollowIf;
        this.entityGetter = entityGetter;
        this.speedModifier = speedModifier;
        this.closeEnough = closeEnough;
        this.tooFar = tooFar;
        this.canFly = canFly;
    }

    public boolean checkExtraStartConditions(ServerLevel level, E mob) {
        if (this.dontFollowIf(mob)) {
            return false;
        }
        Optional<LivingEntity> optional = this.getOwner(mob);
        if (optional.isEmpty() || optional.get().m_5833_()) {
            return false;
        }
        LivingEntity target = optional.get();
        return !mob.m_19950_((Entity)target, (double)this.tooFar.applyAsInt(mob));
    }

    private Optional<LivingEntity> getOwner(E mob) {
        return this.entityGetter.apply(mob);
    }

    public void start(ServerLevel level, E mob, long gameTime) {
        mob.m_6274_().m_21879_((MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get(), (Object)Unit.INSTANCE);
        this.calculatePathCounter = 0;
        this.oldWaterCost = mob.m_21439_(BlockPathTypes.WATER);
        mob.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.goToEntity(mob);
    }

    protected void goToEntity(E mob) {
        AiUtil.setWalkAndLookTargetMemories(mob, (Entity)this.getOwner(mob).get(), this.speedModifier, this.closeEnough);
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    public boolean canStillUse(ServerLevel level, E mob, long gameTime) {
        if (mob.m_21573_().m_26571_()) {
            return false;
        }
        if (this.dontFollowIf(mob)) {
            return false;
        }
        Optional<LivingEntity> entityOptional = this.getOwner(mob);
        if (entityOptional.isEmpty()) {
            return false;
        }
        LivingEntity entity = entityOptional.get();
        return mob.m_20280_((Entity)entity) > (double)Mth.m_144944_((int)this.closeEnough);
    }

    private boolean dontFollowIf(E mob) {
        return this.dontFollowIf.test(mob);
    }

    public void tick(ServerLevel level, E mob, long gameTime) {
        LivingEntity owner = this.getOwner(mob).get();
        BehaviorUtils.m_22595_(mob, (LivingEntity)owner);
        if (--this.calculatePathCounter <= 0) {
            this.calculatePathCounter = 10;
            if (!mob.m_21523_() && !mob.m_20159_()) {
                if (!mob.m_19950_((Entity)owner, (double)((Integer)ABABConfig.petTeleportDistanceTrigger.get()).intValue())) {
                    FollowOwner.teleportToEntity(owner, level, mob, this.canFly);
                } else {
                    this.goToEntity(mob);
                }
            }
        }
    }

    public static void teleportToEntity(LivingEntity owner, ServerLevel level, PathfinderMob mob, boolean canFly) {
        BlockPos ownerCurrentBlockPos = owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int xOffset = FollowOwner.randomIntInclusive(mob, -3, 3);
            int yOffset = FollowOwner.randomIntInclusive(mob, -1, 1);
            int zOffset = FollowOwner.randomIntInclusive(mob, -3, 3);
            boolean teleported = FollowOwner.maybeTeleportTo(owner, level, mob, ownerCurrentBlockPos.m_123341_() + xOffset, ownerCurrentBlockPos.m_123342_() + yOffset, ownerCurrentBlockPos.m_123343_() + zOffset, canFly);
            if (!teleported) continue;
            return;
        }
    }

    private static boolean maybeTeleportTo(LivingEntity owner, ServerLevel level, PathfinderMob mob, int x, int y, int z, boolean canFly) {
        Vec3 ownerCurrentPos = owner.m_20182_();
        if (Math.abs((double)x - ownerCurrentPos.f_82479_) < 2.0 && Math.abs((double)z - ownerCurrentPos.f_82481_) < 2.0) {
            return false;
        }
        if (!FollowOwner.canTeleportTo(level, mob, new BlockPos(x, y, z), canFly)) {
            return false;
        }
        mob.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, mob.m_146908_(), mob.m_146909_());
        GenericAi.stopWalking(mob);
        return true;
    }

    private static boolean canTeleportTo(ServerLevel level, PathfinderMob mob, BlockPos targetPos, boolean canFly) {
        if (CompatUtil.isDILoaded() && DICompat.hasDIAmphibiousEnchant((Mob)mob) && level.m_46801_(targetPos)) {
            return true;
        }
        BlockPathTypes pathTypes = WalkNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)targetPos.m_122032_());
        if (pathTypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = level.m_8055_(targetPos.m_7495_());
        if (!canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = targetPos.m_121996_((Vec3i)mob.m_20183_());
        return level.m_45756_((Entity)mob, mob.m_20191_().m_82338_(blockpos));
    }

    private static int randomIntInclusive(PathfinderMob mob, int min, int max) {
        return mob.m_217043_().m_188503_(max - min + 1) + min;
    }

    public void stop(ServerLevel level, E mob, long gameTime) {
        mob.m_6274_().m_21936_((MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get());
        GenericAi.stopWalking(mob);
        mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }
}

