/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.pet;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.behavior.TargetBehavior;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class CopyOwnerTarget<T extends Mob>
extends TargetBehavior<T> {
    private static final TargetingConditions COPY_OWNER_TARGETING = TargetingConditions.m_148353_().m_148355_().m_26893_();

    public CopyOwnerTarget() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), false);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, T mob) {
        Optional<LivingEntity> owner = AiUtil.getOwner((OwnableEntity)mob);
        if (owner.isEmpty()) {
            return false;
        }
        Optional<LivingEntity> target = AiUtil.getTarget(owner.get());
        return target.isPresent() && this.canAttack(mob, target.get(), COPY_OWNER_TARGETING);
    }

    @Override
    protected void start(ServerLevel level, T mob, long gameTime) {
        AiUtil.getOwner((OwnableEntity)mob).flatMap(AiUtil::getTarget).ifPresent(target -> StartAttacking.m_24213_((Mob)mob, (LivingEntity)target));
        super.start(level, mob, gameTime);
    }
}

