/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.pack;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.common.util.ai.PackAi;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class JoinOrCreatePackAndFollow<E extends LivingEntity>
extends Behavior<E> {
    public static final int INTERVAL_TICKS = 200;
    private final UniformInt followRange;
    private long lastCheckTimestamp;
    private final float speedModifier;

    public JoinOrCreatePackAndFollow(UniformInt followRange, float speedModifier) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.LEADER.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ABABMemoryModuleTypes.FOLLOWERS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ADULTS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_ALLIES.get()), (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.followRange = followRange;
        this.speedModifier = speedModifier;
    }

    protected boolean m_6114_(ServerLevel level, E mob) {
        if (PackAi.hasFollowers(mob)) {
            return false;
        }
        if (PackAi.isFollower(mob)) {
            return this.wantsToFollowLeader(mob);
        }
        if (AiUtil.onCheckCooldown(level, this.lastCheckTimestamp, 200L)) {
            return false;
        }
        this.lastCheckTimestamp = level.m_46467_();
        this.joinOrCreatePack(mob);
        return PackAi.isFollower(mob) && this.wantsToFollowLeader(mob);
    }

    private boolean wantsToFollowLeader(E mob) {
        Optional<LivingEntity> leader = PackAi.getLeader(mob);
        return leader.isPresent() && mob.m_19950_((Entity)leader.get(), (double)(this.followRange.m_142737_() + 1)) && !mob.m_19950_((Entity)leader.get(), (double)this.followRange.m_142739_());
    }

    private void joinOrCreatePack(E mob) {
        List<E> nearbyVisibleAdults = GenericAi.getNearbyVisibleAdults(mob);
        LivingEntity leader = this.findLeader(mob, nearbyVisibleAdults.stream());
        this.addFollowers(leader, nearbyVisibleAdults.stream());
    }

    private LivingEntity findLeader(E mob, Stream<LivingEntity> stream) {
        LivingEntity leader = stream.filter(le -> PackAi.canFollow(mob, le)).findAny().orElse((LivingEntity)mob);
        if (leader != mob) {
            PackAi.startFollowing(mob, leader);
        }
        return leader;
    }

    private void addFollowers(LivingEntity leader, Stream<LivingEntity> stream) {
        stream.filter(le -> le != leader && PackAi.canLead(leader, le)).limit(Math.max(PackAi.getMaxPackSize(leader) - PackAi.getPackSize(leader), 0)).forEach(le -> PackAi.startFollowing(le, leader));
    }

    public void m_6735_(ServerLevel level, E mob, long gameTime) {
        PackAi.pathToLeader(mob, this.speedModifier, this.followRange.m_142739_() - 1);
    }
}

