/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.pack;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.logic.entity_manager.MultiEntityManager;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.PackAi;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class HowlForPack<E extends LivingEntity>
extends Behavior<E> {
    private final Predicate<E> wantsToHowl;
    private final UniformInt howlCooldown;
    private final int tooFar;
    private long lastCheckTimestamp;

    public HowlForPack(Predicate<E> wantsToHowl, UniformInt howlCooldown, int tooFar) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.LEADER.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ABABMemoryModuleTypes.FOLLOWERS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ABABMemoryModuleTypes.HOWLED_RECENTLY.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.wantsToHowl = wantsToHowl;
        this.howlCooldown = howlCooldown;
        this.tooFar = tooFar;
    }

    protected boolean m_6114_(ServerLevel level, E mob) {
        if (!this.wantsToHowl.test(mob)) {
            return false;
        }
        if (AiUtil.onCheckCooldown(level, this.lastCheckTimestamp, 200L)) {
            return false;
        }
        if (PackAi.isFollower(mob)) {
            this.timestampLastCheck(level.m_46467_());
            Optional<LivingEntity> leader = PackAi.getLeader(mob);
            return leader.isPresent() && this.followerTooFar(leader.get(), (Entity)mob);
        }
        if (PackAi.hasFollowers(mob)) {
            this.timestampLastCheck(level.m_46467_());
            MultiEntityManager followers = PackAi.getFollowerManager(mob).get();
            return followers.stream().anyMatch(e -> this.followerTooFar((LivingEntity)mob, (Entity)e));
        }
        return true;
    }

    private void timestampLastCheck(long gameTime) {
        this.lastCheckTimestamp = gameTime;
    }

    private boolean followerTooFar(LivingEntity leader, Entity follower) {
        return !follower.m_19950_((Entity)leader, (double)this.tooFar);
    }

    protected void m_6735_(ServerLevel level, E mob, long gameTime) {
        SharedWolfAi.howl(mob);
        int howlCooldownInTicks = this.howlCooldown.m_214085_(mob.m_217043_());
        SharedWolfAi.setHowledRecently(mob, howlCooldownInTicks);
    }
}

