/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.misc;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class Sprint<E extends Mob>
extends Behavior<E> {
    private final Predicate<E> canSprint;
    private final int tooFar;

    public Sprint() {
        this(e -> true, 0);
    }

    public Sprint(int tooFar) {
        this(e -> true, tooFar);
    }

    public Sprint(Predicate<E> canSprint) {
        this(canSprint, 0);
    }

    public Sprint(Predicate<E> canSprint, int tooFar) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_PRESENT));
        this.canSprint = canSprint;
        this.tooFar = tooFar;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        return this.canSprint.test(mob) && !GenericAi.getWalkTarget(mob).get().m_26420_().m_7024_().m_82509_((Position)mob.m_20182_(), (double)this.tooFar);
    }

    protected void start(ServerLevel level, E mob, long gameTime) {
        mob.m_6858_(true);
    }

    protected boolean canStillUse(ServerLevel level, E mob, long gameTime) {
        return this.canSprint.test(mob) && !mob.m_21573_().m_26571_();
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected void stop(ServerLevel level, E mob, long gameTime) {
        mob.m_6858_(false);
    }
}

