/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.misc;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.registry.ABABActivities;
import com.infamous.all_bark_all_bite.common.util.VectorTracker;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3;

public class PerchAndSearch<E extends PathfinderMob>
extends Behavior<E> {
    private static final float START_CHANCE = 0.02f;
    private final Predicate<E> canPerch;
    private final BiConsumer<E, Boolean> toggleSitting;
    private int lookTime;
    private int looksRemaining;

    public PerchAndSearch(Predicate<E> canPerch, BiConsumer<E, Boolean> toggleSitting) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.canPerch = canPerch;
        this.toggleSitting = toggleSitting;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        return mob.m_21188_() == null && mob.m_217043_().m_188501_() <= 0.02f && mob.m_21573_().m_26571_() && this.canPerch.test(mob);
    }

    protected void start(ServerLevel level, E mob, long gameTime) {
        this.resetLook(mob);
        this.looksRemaining = 2 + mob.m_217043_().m_188503_(3);
        this.toggleSitting.accept(mob, true);
        GenericAi.stopWalking(mob);
    }

    private void resetLook(E mob) {
        RandomSource random = mob.m_217043_();
        double randomLookAngle = Math.PI * 2 * random.m_188500_();
        double relX = Math.cos(randomLookAngle);
        double relZ = Math.sin(randomLookAngle);
        this.lookTime = 80 + random.m_188503_(20);
        Vec3 lookAtPos = new Vec3(mob.m_20185_() + relX, mob.m_20188_(), mob.m_20189_() + relZ);
        mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new VectorTracker(lookAtPos));
    }

    protected void tick(ServerLevel level, E mob, long gameTime) {
        --this.lookTime;
        if (this.lookTime <= 0) {
            --this.looksRemaining;
            this.resetLook(mob);
        }
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected boolean canStillUse(ServerLevel level, E mob, long gameTime) {
        return this.looksRemaining > 0 && GenericAi.getWalkTarget(mob).isEmpty();
    }

    protected void stop(ServerLevel level, E mob, long gameTime) {
        if (!mob.m_6274_().m_21954_((Activity)ABABActivities.SIT.get())) {
            this.toggleSitting.accept(mob, false);
        }
    }
}

