/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.misc;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class HurtByEntityTrigger<E extends LivingEntity>
extends Behavior<E> {
    private final BiPredicate<E, LivingEntity> canUse;
    private final BiConsumer<E, LivingEntity> onHurtBy;
    private DamageSource lastHurtBy;

    public HurtByEntityTrigger(BiConsumer<E, LivingEntity> onHurtBy) {
        this((m, le) -> true, onHurtBy);
    }

    public HurtByEntityTrigger(BiPredicate<E, LivingEntity> canUse, BiConsumer<E, LivingEntity> onHurtBy) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26381_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26382_, (Object)MemoryStatus.VALUE_PRESENT));
        this.canUse = canUse;
        this.onHurtBy = onHurtBy;
    }

    protected boolean m_6114_(ServerLevel level, E mob) {
        return this.isNotAlreadyReacting(mob) && this.canUse.test(mob, this.getHurtByEntity((LivingEntity)mob).get());
    }

    private boolean isNotAlreadyReacting(E mob) {
        DamageSource hurtBy = this.getHurtBy((LivingEntity)mob).get();
        LivingEntity hurtByEntity = this.getHurtByEntity((LivingEntity)mob).get();
        return this.lastHurtBy == null || this.lastHurtBy != hurtBy && hurtBy.m_7639_() == hurtByEntity;
    }

    protected void m_6735_(ServerLevel level, E mob, long gameTime) {
        this.lastHurtBy = this.getHurtBy((LivingEntity)mob).get();
        this.onHurtBy.accept(mob, this.getHurtByEntity((LivingEntity)mob).get());
    }

    private Optional<DamageSource> getHurtBy(LivingEntity mob) {
        return mob.m_6274_().m_21952_(MemoryModuleType.f_26381_);
    }

    private Optional<LivingEntity> getHurtByEntity(LivingEntity mob) {
        return mob.m_6274_().m_21952_(MemoryModuleType.f_26382_);
    }
}

