/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.long_jump;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.common.util.ai.LongJumpAi;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class LeapAtTarget
extends Behavior<PathfinderMob> {
    private static final double MIN_Y_DELTA = 0.05;
    private static final int CROUCH_ANIMATION_DURATION = 4;
    private final float yD;
    private final int tooClose;
    private final int tooFar;
    private int crouchAnimationTimer;
    private State state = State.DONE;
    private final UniformInt jumpCooldown;

    public LeapAtTarget(float yD, int tooClose, int tooFar, UniformInt jumpCooldown) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), 100);
        this.yD = yD;
        this.tooClose = tooClose;
        this.tooFar = tooFar;
        this.jumpCooldown = jumpCooldown;
    }

    public boolean checkExtraStartConditions(ServerLevel level, PathfinderMob mob) {
        if (mob.m_20160_()) {
            return false;
        }
        LivingEntity attackTarget = GenericAi.getAttackTarget((LivingEntity)mob).get();
        if (!mob.m_19950_((Entity)attackTarget, (double)this.tooClose) && mob.m_20280_((Entity)attackTarget) <= (double)Mth.m_144944_((int)this.tooFar)) {
            return mob.m_20096_();
        }
        return false;
    }

    public void start(ServerLevel level, PathfinderMob mob, long gameTime) {
        this.state = State.CROUCH_ANIMATION;
        mob.m_20124_(Pose.CROUCHING);
        this.crouchAnimationTimer = 0;
        GenericAi.stopWalking(mob);
    }

    public boolean canStillUse(ServerLevel level, PathfinderMob mob, long gameTime) {
        LivingEntity attackTarget = GenericAi.getAttackTarget((LivingEntity)mob).orElse(null);
        if (attackTarget != null) {
            switch (this.state) {
                case CROUCH_ANIMATION: 
                case LEAP: {
                    return attackTarget.m_6084_() && mob.m_217003_(Pose.CROUCHING);
                }
                case MID_LEAP: {
                    double yD = mob.m_20184_().f_82480_;
                    return Mth.m_144952_((double)yD) >= 0.05 || !mob.m_20096_();
                }
            }
            return false;
        }
        return false;
    }

    protected void tick(ServerLevel p_22551_, PathfinderMob mob, long p_22553_) {
        LivingEntity target = GenericAi.getAttackTarget((LivingEntity)mob).get();
        switch (this.state) {
            case CROUCH_ANIMATION: {
                if (this.crouchAnimationTimer++ < 4) break;
                this.state = State.LEAP;
                break;
            }
            case LEAP: {
                mob.m_20124_(Pose.LONG_JUMPING);
                LongJumpAi.setMidJump((LivingEntity)mob);
                Vec3 deltaMovement = mob.m_20184_();
                Vec3 xzD = new Vec3(target.m_20185_() - mob.m_20185_(), 0.0, target.m_20189_() - mob.m_20189_());
                if (xzD.m_82556_() > 1.0E-6) {
                    xzD = xzD.m_82541_().m_82490_(0.4).m_82549_(deltaMovement.m_82490_(0.2));
                }
                mob.m_20334_(xzD.f_82479_, (double)this.yD, xzD.f_82481_);
                this.state = State.MID_LEAP;
            }
        }
    }

    protected void stop(ServerLevel level, PathfinderMob mob, long gameTime) {
        if (this.state == State.CROUCH_ANIMATION || this.state == State.LEAP) {
            AiUtil.resetPose((LivingEntity)mob, Pose.CROUCHING);
        } else if (this.state == State.MID_LEAP) {
            AiUtil.resetPose((LivingEntity)mob, Pose.LONG_JUMPING);
        }
        this.state = State.DONE;
        LongJumpAi.clearMidJump((LivingEntity)mob);
        LongJumpAi.setLongJumpCooldown((LivingEntity)mob, this.jumpCooldown.m_214085_(mob.m_217043_()));
    }

    static enum State {
        CROUCH_ANIMATION,
        LEAP,
        MID_LEAP,
        DONE;

    }
}

