/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.item;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class GiveItemToTarget<E extends LivingEntity>
extends Behavior<E> {
    private final Function<E, ItemStack> itemGetter;
    private final Function<E, Optional<LivingEntity>> targetGetter;
    private final int closeEnough;
    private final Consumer<E> onThrown;
    private final int throwYOffset;

    public GiveItemToTarget(Function<E, ItemStack> itemGetter, Function<E, Optional<LivingEntity>> targetGetter, int closeEnough, Consumer<E> onThrown) {
        this(itemGetter, targetGetter, closeEnough, 0, onThrown);
    }

    public GiveItemToTarget(Function<E, ItemStack> itemGetter, Function<E, Optional<LivingEntity>> targetGetter, int closeEnough, int throwYOffset, Consumer<E> onThrown) {
        super(Map.of(MemoryModuleType.f_26371_, MemoryStatus.REGISTERED, MemoryModuleType.f_26370_, MemoryStatus.REGISTERED));
        this.itemGetter = itemGetter;
        this.targetGetter = targetGetter;
        this.closeEnough = closeEnough;
        this.throwYOffset = throwYOffset;
        this.onThrown = onThrown;
    }

    protected boolean m_6114_(ServerLevel level, E mob) {
        if (this.itemGetter.apply(mob).m_41619_()) {
            return false;
        }
        Optional<LivingEntity> target = this.targetGetter.apply(mob);
        if (target.isEmpty() || target.get().m_5833_()) {
            return false;
        }
        return mob.m_20280_((Entity)target.get()) <= (double)Mth.m_144944_((int)this.closeEnough);
    }

    protected void m_6735_(ServerLevel level, E mob, long gameTime) {
        ItemStack toThrow = this.itemGetter.apply(mob).m_41620_(1);
        if (!toThrow.m_41619_()) {
            BehaviorUtils.m_22613_(mob, (ItemStack)toThrow, (Vec3)this.getThrowPosition(this.targetGetter.apply(mob).get()));
            this.onThrown.accept(mob);
        }
    }

    private Vec3 getThrowPosition(LivingEntity target) {
        return target.m_20182_().m_82520_(0.0, (double)this.throwYOffset, 0.0);
    }
}

