/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.hunter;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.util.ai.HunterAi;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class RememberIfHuntTargetWasKilled<E extends LivingEntity>
extends Behavior<E> {
    private final BiPredicate<E, LivingEntity> huntTargetPredicate;
    private final UniformInt huntCooldown;

    public RememberIfHuntTargetWasKilled(BiPredicate<E, LivingEntity> huntTargetPredicate, UniformInt huntCooldown) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26340_, (Object)MemoryStatus.REGISTERED));
        this.huntTargetPredicate = huntTargetPredicate;
        this.huntCooldown = huntCooldown;
    }

    protected void m_6735_(ServerLevel level, E mob, long gameTime) {
        if (this.isAttackTargetHuntTarget(mob)) {
            HunterAi.setHuntedRecently(mob, this.huntCooldown.m_214085_(mob.m_217043_()));
        }
    }

    private boolean isAttackTargetHuntTarget(E mob) {
        LivingEntity attackTarget = (LivingEntity)mob.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        return this.huntTargetPredicate.test(mob, attackTarget) && attackTarget.m_21224_();
    }
}

