/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior.dig;

import com.google.common.collect.ImmutableMap;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.DigAi;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;

public class DigAtLocation<E extends LivingEntity>
extends Behavior<E> {
    private static final long CHECK_COOLDOWN = 40L;
    private long lastCheckTimestamp;
    private final Consumer<E> onDigCompleted;
    private final long digDuration;
    private long digUpAtTime;

    public DigAtLocation(Consumer<E> onDigCompleted, long digDuration) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ABABMemoryModuleTypes.DIG_LOCATION.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.onDigCompleted = onDigCompleted;
        this.digDuration = digDuration;
    }

    protected boolean m_6114_(ServerLevel level, E mob) {
        if (AiUtil.onCheckCooldown(level, this.lastCheckTimestamp, 40L)) {
            return false;
        }
        this.lastCheckTimestamp = level.m_46467_();
        GlobalPos digLocation = DigAi.getDigLocation(mob).get();
        return digLocation.m_122640_() == level.m_46472_() && digLocation.m_122646_().m_203195_((Position)mob.m_20182_(), 1.0);
    }

    protected void m_6735_(ServerLevel level, E mob, long gameTime) {
        this.lookAtDigLocation(mob);
        mob.m_20124_(Pose.DIGGING);
        this.digUpAtTime = gameTime + this.digDuration;
    }

    private void lookAtDigLocation(E mob) {
        DigAi.getDigLocation(mob).ifPresent(bp -> mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(bp.m_122646_())));
    }

    protected void m_6725_(ServerLevel level, E mob, long gameTime) {
        if (gameTime % 4L == 0L) {
            DigAi.getDigLocation(mob).ifPresent(bp -> this.playDiggingSound(level, mob, bp.m_122646_()));
        }
        if (gameTime >= this.digUpAtTime) {
            this.onDigCompleted.accept(mob);
            mob.m_6274_().m_21936_((MemoryModuleType)ABABMemoryModuleTypes.DIG_LOCATION.get());
        }
    }

    private void playDiggingSound(ServerLevel level, E mob, BlockPos bp) {
        SoundType soundType = level.m_8055_(bp.m_7495_()).getSoundType((LevelReader)level, bp, mob);
        mob.m_216990_(soundType.m_56778_());
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected boolean m_6737_(ServerLevel level, E mob, long gameTime) {
        Optional<GlobalPos> optional = DigAi.getDigLocation(mob);
        if (optional.isEmpty()) {
            return false;
        }
        GlobalPos globalpos = optional.get();
        return globalpos.m_122640_() == level.m_46472_() && globalpos.m_122646_().m_203195_((Position)mob.m_20182_(), 1.0);
    }

    protected void m_6732_(ServerLevel level, E mob, long gameTime) {
        this.digUpAtTime = 0L;
        AiUtil.resetPose(mob, Pose.DIGGING);
    }
}

