/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public abstract class TargetBehavior<E extends Mob>
extends Behavior<E> {
    private static final int EMPTY_REACH_CACHE = 0;
    private static final int CAN_REACH_CACHE = 1;
    private static final int CANT_REACH_CACHE = 2;
    private static final double WITHIN_PATH_XZ = 1.5;
    private final boolean mustReach;
    private int reachCache;
    private int reachCacheTime;

    public TargetBehavior(Map<MemoryModuleType<?>, MemoryStatus> additionalMemories, boolean mustReach) {
        super((Map)ImmutableMap.builder().putAll(additionalMemories).put((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.REGISTERED).put((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED).build());
        this.mustReach = mustReach;
    }

    protected void start(ServerLevel level, E mob, long gameTime) {
        this.reachCache = 0;
        this.reachCacheTime = 0;
    }

    protected boolean canAttack(E mob, @Nullable LivingEntity target, TargetingConditions conditions) {
        if (target == null) {
            return false;
        }
        if (!conditions.m_26885_(mob, target)) {
            return false;
        }
        if (!mob.m_21444_(target.m_20183_())) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                this.reachCache = this.canReach(mob, target) ? 1 : 2;
            }
            return this.reachCache != 2;
        }
        return true;
    }

    private boolean canReach(E mob, LivingEntity target) {
        int zDiff;
        this.reachCacheTime = 10 + mob.m_217043_().m_188503_(5);
        Path pathToTarget = mob.m_21573_().m_6570_((Entity)target, 0);
        if (pathToTarget == null) {
            return false;
        }
        Node endNode = pathToTarget.m_77395_();
        if (endNode == null) {
            return false;
        }
        int xDiff = endNode.f_77271_ - target.m_146903_();
        return (double)(xDiff * xDiff + (zDiff = endNode.f_77273_ - target.m_146907_()) * zDiff) <= Mth.m_144952_((double)1.5);
    }
}

