/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common;

import com.google.common.collect.Maps;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.compat.CompatUtil;
import com.infamous.all_bark_all_bite.common.compat.DICompat;
import com.infamous.all_bark_all_bite.common.entity.DogSpawner;
import com.infamous.all_bark_all_bite.common.entity.dog.Dog;
import com.infamous.all_bark_all_bite.common.entity.dog.DogHooks;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfAi;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfHooks;
import com.infamous.all_bark_all_bite.common.goal.LookAtTargetSinkGoal;
import com.infamous.all_bark_all_bite.common.goal.MoveToTargetSinkGoal;
import com.infamous.all_bark_all_bite.common.item.PetWhistleItem;
import com.infamous.all_bark_all_bite.common.logic.ABABRaiderTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABEntityTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABItems;
import com.infamous.all_bark_all_bite.common.util.ReflectionUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="all_bark_all_bite")
public class ForgeEventHandler {
    private static final Map<ResourceKey<Level>, List<CustomSpawner>> CUSTOM_SPAWNERS = Maps.newLinkedHashMap();
    private static final String FOX_IS_DEFENDING = "m_28567_";

    @SubscribeEvent
    static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.END) {
                MinecraftServer server = serverLevel.m_7654_();
                ResourceKey dimension = serverLevel.m_46472_();
                List customSpawners = CUSTOM_SPAWNERS.computeIfAbsent((ResourceKey<Level>)dimension, k -> {
                    ArrayList<DogSpawner> spawners = new ArrayList<DogSpawner>();
                    if (k == Level.f_46428_) {
                        spawners.add(new DogSpawner());
                    }
                    return spawners;
                });
                customSpawners.forEach(cs -> cs.m_7995_(serverLevel, server.m_7004_(), server.m_6998_()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        PathfinderMob pathfinderMob;
        if (event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        ForgeEventHandler.addMobDogInteractionGoals(entity);
        if (entity.m_6095_() == EntityType.f_20499_) {
            WolfHooks.onWolfJoinLevel((Wolf)entity, event.loadedFromDisk());
        }
        if (entity instanceof PathfinderMob && !(pathfinderMob = (PathfinderMob)entity).m_6274_().m_21876_(MemoryModuleType.f_26370_, MemoryStatus.REGISTERED) && (entity instanceof OwnableEntity || entity instanceof AbstractHorse)) {
            pathfinderMob.f_21345_.m_25352_(0, (Goal)new MoveToTargetSinkGoal(pathfinderMob));
            pathfinderMob.f_21345_.m_25352_(0, (Goal)new LookAtTargetSinkGoal(pathfinderMob));
        }
    }

    private static void addMobDogInteractionGoals(Entity mob) {
        EntityType type = mob.m_6095_();
        if (mob instanceof Fox) {
            Fox fox = (Fox)mob;
            if (type.m_204039_(ABABTags.DOG_ALWAYS_HOSTILES)) {
                fox.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)fox, Dog.class, 8.0f, 1.6, 1.4, le -> !((Dog)le).m_21824_() && (Boolean)ReflectionUtil.callMethod(FOX_IS_DEFENDING, fox, new Object[0]) == false));
            }
        }
        if (mob instanceof Rabbit) {
            final Rabbit rabbit = (Rabbit)mob;
            if (type.m_204039_(ABABTags.DOG_HUNT_TARGETS)) {
                rabbit.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal<Dog>((PathfinderMob)rabbit, Dog.class, 10.0f, 2.2, 2.2){

                    public boolean m_8036_() {
                        return rabbit.m_29719_() != 99 && super.m_8036_();
                    }
                });
            }
        }
        if (mob instanceof AbstractSkeleton) {
            AbstractSkeleton skeleton = (AbstractSkeleton)mob;
            if (type.m_204039_(ABABTags.DOG_ALWAYS_HOSTILES)) {
                skeleton.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)skeleton, Dog.class, 6.0f, 1.0, 1.2));
            }
        }
        if (mob instanceof Llama) {
            Llama llama = (Llama)mob;
            if (type.m_204039_(ABABTags.DOG_DISLIKED)) {
                llama.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Dog>((Mob)llama, Dog.class, 16, false, true, le -> !((Dog)le).m_21824_()){

                    protected double m_7623_() {
                        return super.m_7623_() * 0.25;
                    }
                });
            }
        }
    }

    @SubscribeEvent
    static void onEntitySize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_() == EntityType.f_20499_) {
            EntityDimensions resize = WolfHooks.onWolfSize(entity, event.getNewSize());
            event.setNewSize(resize, true);
        } else if (entity.m_6095_() == ABABEntityTypes.DOG.get()) {
            EntityDimensions newSize = DogHooks.onDogSize(entity, event.getNewSize());
            event.setNewSize(newSize, true);
        }
    }

    @SubscribeEvent
    static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (!event.isCanceled() && entity.m_6095_() == EntityType.f_20499_ && !level.f_46443_) {
            WolfHooks.onWolfUpdate((Wolf)entity, (ServerLevel)level);
        }
    }

    @SubscribeEvent
    static void onLivingFall(LivingFallEvent event) {
        if (event.getEntity().m_6095_() == EntityType.f_20499_) {
            event.setDistance(event.getDistance() - 2.0f);
        }
    }

    @SubscribeEvent
    static void onSleepPosCheck(SleepingLocationCheckEvent event) {
        EntityType type = event.getEntity().m_6095_();
        if (type == EntityType.f_20499_ || type == ABABEntityTypes.DOG.get()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        if (!player.m_5833_() && CompatUtil.isDILoaded()) {
            BlockPos blockPos;
            Level level = player.m_9236_();
            boolean noSneakBypassUse = !player.m_21093_(arg_0 -> ForgeEventHandler.lambda$onRightClickBlock$4(level, blockPos = event.getPos(), player, arg_0));
            boolean sneakBypass = player.m_36341_() && noSneakBypassUse;
            Event.Result useBlock = event.getUseBlock();
            if (useBlock == Event.Result.ALLOW || useBlock != Event.Result.DENY && !sneakBypass) {
                BlockState blockState = level.m_8055_(blockPos);
                DICompat.handleDIDrum(player, level, blockPos, blockState);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_150930_((Item)ABABItems.WHISTLE.get()) && PetWhistleItem.interactWithPet(itemStack, player, target, event.getHand())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (!itemStack.m_204117_(ABABTags.HAS_WOLF_INTERACTION) && !player.m_36341_() && target.m_6095_() == EntityType.f_20499_) {
            event.setCanceled(true);
            event.setCancellationResult(AiUtil.interactOn(player, (Wolf)target, event.getHand(), WolfAi::mobInteract));
        }
    }

    @SubscribeEvent
    static void onBabySpawn(BabyEntitySpawnEvent event) {
        AgeableMob child = event.getChild();
        if (child != null && child.m_6095_() == EntityType.f_20499_) {
            WolfHooks.onWolfPupSpawn((Wolf)child, event.getCausedByPlayer());
        }
    }

    @SubscribeEvent
    static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        Level level = event.getEntity().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.getItem().m_150930_((Item)ABABItems.WHISTLE.get())) {
                PetWhistleItem.onItemUseStart(event.getEntity(), event.getItem(), serverLevel);
            }
        }
    }

    @SubscribeEvent
    static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_6095_() == EntityType.f_20499_) {
            WolfHooks.onWolfJump(entity);
        }
    }

    @SubscribeEvent
    static void onServerStarting(ServerAboutToStartEvent event) {
        ABABRaiderTypes.refreshHoundmasterRaiderType();
    }

    private static /* synthetic */ boolean lambda$onRightClickBlock$4(Level level, BlockPos blockPos, Player player, ItemStack is) {
        return is.doesSneakBypassUse((LevelReader)level, blockPos, player);
    }
}

