/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.infamous.all_bark_all_bite.common.item.PetWhistleItem;
import com.infamous.all_bark_all_bite.common.network.ABABNetwork;
import com.infamous.all_bark_all_bite.common.network.ServerboundAdjustInstrumentPacket;
import com.infamous.all_bark_all_bite.common.network.ServerboundUnbindPetWhistlePacket;
import com.infamous.all_bark_all_bite.common.util.InstrumentUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.ItemStack;

public class WhistleScreen
extends Screen {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)PetWhistleItem.CONTAINER_TITLE_ID);
    private static final Component UNBIND_BUTTON_LABEL = Component.m_237115_((String)PetWhistleItem.UNBIND_BUTTON_LABEL_ID);
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("all_bark_all_bite", "textures/gui/whistle.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int INSTRUMENTS_COLUMNS = 1;
    private static final int INSTRUMENTS_ROWS = 3;
    private static final int INSTRUMENTS_IMAGE_SIZE_WIDTH = 64;
    private static final int INSTRUMENTS_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int INSTRUMENTS_X = 52;
    private static final int INSTRUMENTS_Y = 14;
    private static final int INSTRUMENT_NAME_COLOR = 0xCCCCCC;
    private static final int UNBIND_BUTTON_WIDTH = 36;
    private static final int UNBIND_BUTTON_HEIGHT = 20;
    private static final int UNBIND_BUTTON_X = 9;
    private static final int UNBIND_BUTTON_Y = 32;
    protected int imageWidth = 176;
    protected int imageHeight = 84;
    private final Player owner;
    private final ItemStack whistle;
    private final InteractionHand hand;
    private final List<Holder<Instrument>> instruments;
    private int selectedInstrumentIndex = -1;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private int leftPos;
    private int topPos;
    private Button unbindButton;

    public WhistleScreen(Player owner, ItemStack whistle, InteractionHand hand, Iterable<Holder<Instrument>> instruments) {
        super(CONTAINER_TITLE);
        this.owner = owner;
        this.whistle = whistle;
        this.hand = hand;
        this.instruments = ImmutableList.copyOf(instruments);
        this.f_96541_ = Minecraft.m_91087_();
        this.f_96542_ = this.f_96541_.m_91291_();
        this.f_96547_ = this.f_96541_.f_91062_;
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.unbindButton = (Button)this.m_142416_((GuiEventListener)new Button(this.leftPos + 9, this.topPos + 32, 36, 20, UNBIND_BUTTON_LABEL, button -> {
            this.unbindWhistle();
            this.updateUnbindButton();
        }));
        this.updateUnbindButton();
    }

    private void updateUnbindButton() {
        this.unbindButton.f_93623_ = PetWhistleItem.getBoundTo(this.whistle) != null;
    }

    public boolean m_7933_(int keysym, int scancode, int p_97767_) {
        InputConstants.Key key = InputConstants.m_84827_((int)keysym, (int)scancode);
        if (super.m_7933_(keysym, scancode, p_97767_)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderBg(poseStack, mouseX, mouseY);
        this.renderTooltip(poseStack, mouseX, mouseY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    protected void renderBg(PoseStack poseStack, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        this.m_7522_(null);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG_LOCATION);
        int i = this.leftPos;
        int j = this.topPos;
        this.m_93228_(poseStack, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollOffs);
        this.m_93228_(poseStack, i + 119, j + 15 + k, this.imageWidth + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int instrumentsLeftPos = this.leftPos + 52;
        int instrumentsTopPos = this.topPos + 14;
        int stopIndex = this.startIndex + this.getMaxDisplayButtons();
        this.renderButtons(poseStack, mouseX, mouseY, instrumentsLeftPos, instrumentsTopPos, stopIndex);
        this.renderInstruments(poseStack, instrumentsLeftPos, instrumentsTopPos, stopIndex);
    }

    protected void renderTooltip(PoseStack poseStack, int mouseX, int mouseY) {
        int instrumentsLeftPos = this.leftPos + 52;
        int instrumentsTopPos = this.topPos + 14;
        int stopIndex = this.startIndex + this.getMaxDisplayButtons();
        for (int index = this.startIndex; index < stopIndex && index < this.instruments.size(); ++index) {
            int indexDiff = index - this.startIndex;
            int x = instrumentsLeftPos + indexDiff % 1 * 64;
            int y = instrumentsTopPos + indexDiff / 1 * 18 + 2;
            if (mouseX < x || mouseX >= x + 64 || mouseY < y || mouseY >= y + 18) continue;
            this.m_169388_(poseStack, WhistleScreen.getInstrumentTooltipLines(this.instruments.get(index)), Optional.empty(), mouseX, mouseY);
        }
    }

    private static List<Component> getInstrumentTooltipLines(Holder<Instrument> instrument) {
        ArrayList tooltipLines = Lists.newArrayList();
        MutableComponent instrumentTooltip = InstrumentUtil.getInstrumentTooltip(instrument);
        tooltipLines.add(instrumentTooltip.m_130940_(ChatFormatting.WHITE));
        MutableComponent descriptionTooltip = InstrumentUtil.getInstrumentDescriptionTooltip(instrument);
        tooltipLines.add(descriptionTooltip.m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        return tooltipLines;
    }

    private void renderButtons(PoseStack poseStack, int mouseX, int mouseY, int instrumentsLeftPos, int instrumentsTopPos, int stopIndex) {
        for (int index = this.startIndex; index < stopIndex && index < this.instruments.size(); ++index) {
            int indexDiff = index - this.startIndex;
            int x = instrumentsLeftPos + indexDiff % 1 * 64;
            int columns = indexDiff / 1;
            int y = instrumentsTopPos + columns * 18 + 2;
            int buttonY = this.imageHeight;
            if (index == this.selectedInstrumentIndex) {
                buttonY += 18;
            } else if (mouseX >= x && mouseY >= y && mouseX < x + 64 && mouseY < y + 18) {
                buttonY += 36;
            }
            this.m_93228_(poseStack, x, y - 1, 0, buttonY, 64, 18);
        }
    }

    private void renderInstruments(PoseStack poseStack, int instrumentsLeftPos, int instrumentsTopPos, int stopIndex) {
        for (int index = this.startIndex; index < stopIndex && index < this.instruments.size(); ++index) {
            int indexDiff = index - this.startIndex;
            int x = instrumentsLeftPos + indexDiff % 1 * 64 + 16;
            int columns = indexDiff / 1;
            int y = instrumentsTopPos + columns * 18 + 2 + 6;
            this.f_96547_.m_92889_(poseStack, (Component)InstrumentUtil.getInstrumentTooltip(this.instruments.get(index)), (float)x, (float)y, 0xCCCCCC);
        }
    }

    public boolean m_6375_(double x, double y, int p_99320_) {
        this.scrolling = false;
        int instrumentsLeftPos = this.leftPos + 52;
        int instrumentsTopPos = this.topPos + 14;
        int width = this.startIndex + this.getMaxDisplayButtons();
        for (int index = this.startIndex; index < width; ++index) {
            int i1 = index - this.startIndex;
            double adjustedClickX = x - (double)(instrumentsLeftPos + i1 % 1 * 64);
            double adjustedClickY = y - (double)(instrumentsTopPos + i1 / 1 * 18);
            if (!(adjustedClickX >= 0.0) || !(adjustedClickY >= 0.0) || !(adjustedClickX < 64.0) || !(adjustedClickY < 18.0) || !this.clickMenuButton(index)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.updateInstrument(this.instruments.get(this.selectedInstrumentIndex));
            return true;
        }
        instrumentsLeftPos = this.leftPos + 119;
        instrumentsTopPos = this.topPos + 9;
        if (x >= (double)instrumentsLeftPos && x < (double)(instrumentsLeftPos + 12) && y >= (double)instrumentsTopPos && y < (double)(instrumentsTopPos + 54)) {
            this.scrolling = true;
        }
        return super.m_6375_(x, y, p_99320_);
    }

    private boolean clickMenuButton(int index) {
        if (this.isValidInstrumentIndex(index)) {
            this.selectedInstrumentIndex = index;
            return true;
        }
        return false;
    }

    private boolean isValidInstrumentIndex(int index) {
        return index >= 0 && index < this.instruments.size();
    }

    public boolean m_7979_(double p_99322_, double p_99323_, int p_99324_, double p_99325_, double p_99326_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.scrollOffs = ((float)p_99323_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 1;
            return true;
        }
        return super.m_7979_(p_99322_, p_99323_, p_99324_, p_99325_, p_99326_);
    }

    public boolean m_6050_(double p_99314_, double p_99315_, double p_99316_) {
        if (this.isScrollBarActive()) {
            int offscreenRows = this.getOffscreenRows();
            float f = (float)p_99316_ / (float)offscreenRows;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)offscreenRows) + 0.5) * 1;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.instruments.size() > this.getMaxDisplayButtons();
    }

    private int getMaxDisplayButtons() {
        return 3;
    }

    protected int getOffscreenRows() {
        return (this.instruments.size() + 1 - 1) / Math.max(1, -2);
    }

    private void updateInstrument(Holder<Instrument> instrument) {
        InstrumentUtil.setSoundVariantId(this.whistle, instrument);
        ABABNetwork.INSTANCE.sendToServer((Object)new ServerboundAdjustInstrumentPacket(this.getSlot(), InstrumentUtil.getInstrumentLocation(instrument)));
    }

    private int getSlot() {
        return this.hand == InteractionHand.MAIN_HAND ? this.owner.m_150109_().f_35977_ : 40;
    }

    private void unbindWhistle() {
        PetWhistleItem.unbind(this.whistle);
        ABABNetwork.INSTANCE.sendToServer((Object)new ServerboundUnbindPetWhistlePacket(this.getSlot()));
    }
}

