/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.client.renderer.model;

import com.infamous.all_bark_all_bite.client.renderer.model.animation.DogAnimation;
import com.infamous.all_bark_all_bite.common.entity.AnimationControllerAccess;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAnimationController;
import com.infamous.all_bark_all_bite.common.entity.dog.Dog;
import com.infamous.all_bark_all_bite.mixin.WolfAccessor;
import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class DogModel<T extends Dog>
extends ColorableHierarchicalModel<T>
implements HeadedModel {
    public static final String HEAD = "head";
    public static final String BODY = "body";
    public static final String UPPER_BODY = "upper_body";
    public static final String RIGHT_HIND_LEG = "right_hind_leg";
    public static final String LEFT_HIND_LEG = "left_hind_leg";
    public static final String RIGHT_FRONT_LEG = "right_front_leg";
    public static final String LEFT_FRONT_LEG = "left_front_leg";
    public static final String TAIL = "tail";
    private static final String DOG_TAG = "dog_tag";
    public static final float IDLE_SLEEP_ANIMATION_SPEED = 0.5f;
    private final ModelPart dogTag;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart upperBody;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private float partialTicks;

    public DogModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_(HEAD);
        this.body = root.m_171324_(BODY);
        this.upperBody = this.body.m_171324_(UPPER_BODY);
        this.dogTag = this.upperBody.m_171324_(DOG_TAG);
        this.dogTag.f_104207_ = false;
        this.rightHindLeg = root.m_171324_(RIGHT_HIND_LEG);
        this.leftHindLeg = root.m_171324_(LEFT_HIND_LEG);
        this.rightFrontLeg = root.m_171324_(RIGHT_FRONT_LEG);
        this.leftFrontLeg = root.m_171324_(LEFT_FRONT_LEG);
        this.tail = root.m_171324_(TAIL);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition head = root.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-2.0f, -3.0f, -3.0f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(32, 33).m_171488_(-0.5f, -0.02f, -6.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)12.0f, (float)-4.5f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171488_(-2.964f, -3.005f, -0.8733f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.2285f, (float)-0.1606f, (float)-0.3867f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171480_().m_171488_(0.0f, -3.0f, -1.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-3.0f, (float)0.0f, (float)0.2285f, (float)0.1606f, (float)0.3867f));
        PartDefinition body = root.m_171599_(BODY, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)2.5f));
        PartDefinition body_rotation_r1 = body.m_171599_("body_rotation_r1", CubeListBuilder.m_171558_().m_171514_(32, 18).m_171488_(-4.0f, 0.0f, -6.5f, 8.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-6.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body_rotation_r2 = body.m_171599_("body_rotation_r2", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -5.0f, -4.5f, 8.0f, 13.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-1.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body_rotation = body.m_171599_("body_rotation", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-0.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition mane = body.m_171599_(UPPER_BODY, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition mane_rotation = mane.m_171599_("mane_rotation", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -7.0f, -8.0f, 9.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tag = mane.m_171599_(DOG_TAG, CubeListBuilder.m_171558_().m_171514_(40, 11).m_171488_(-1.0f, -7.75f, -3.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = root.m_171599_(RIGHT_HIND_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)7.0f));
        PartDefinition leg2 = root.m_171599_(LEFT_HIND_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)7.0f));
        PartDefinition leg3 = root.m_171599_(RIGHT_FRONT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)-2.0f));
        PartDefinition leg4 = root.m_171599_(LEFT_FRONT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)-2.0f));
        PartDefinition tail = root.m_171599_(TAIL, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)51, (int)51);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void prepareMobModel(T dog, float animPos, float lerpAnimSpeed, float partialTicks) {
        this.partialTicks = partialTicks;
        this.dogTag.f_104207_ = dog.m_21824_() && dog.m_8077_();
    }

    public void setupAnim(T dog, float animPos, float lerpAnimSpeed, float bob, float headYRot, float headXRot) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateHeadLookTarget(headYRot, headXRot);
        AnimationControllerAccess aca = AnimationControllerAccess.cast(dog);
        SharedWolfAnimationController animationController = (SharedWolfAnimationController)aca.getAnimationController();
        this.m_233381_(animationController.attackAnimationState, DogAnimation.ATTACK, bob);
        this.m_233381_(animationController.babyAnimationState, DogAnimation.BABY, bob);
        this.m_233381_(animationController.crouchAnimationState, DogAnimation.CROUCH, bob);
        this.m_233381_(animationController.digAnimationState, DogAnimation.DIG, bob);
        this.m_233381_(animationController.idleAnimationState, DogAnimation.IDLE, bob);
        this.m_233381_(animationController.idleDigAnimationState, DogAnimation.IDLE_DIG, bob);
        this.m_233381_(animationController.idleSitAnimationState, DogAnimation.IDLE_SIT, bob);
        this.m_233385_(animationController.idleSleepAnimationState, DogAnimation.IDLE_SLEEP, bob, 0.5f);
        this.m_233381_(animationController.jumpAnimationState, DogAnimation.JUMP, bob);
        this.m_233381_(animationController.leapAnimationState, DogAnimation.LEAP, bob);
        this.m_233381_(animationController.sitAnimationState, DogAnimation.SIT, bob);
        this.m_233381_(animationController.sleepAnimationState, DogAnimation.SLEEP, bob);
        this.m_233381_(animationController.sprintAnimationState, DogAnimation.SPRINT, bob);
        this.m_233381_(animationController.walkAnimationState, DogAnimation.WALK, bob);
        this.animateInterestAndShaking(dog, this.partialTicks);
    }

    private void animateInterestAndShaking(T dog, float partialTicks1) {
        boolean interested = dog.m_30429_();
        boolean shaking = ((WolfAccessor)dog).getIsShaking();
        if (interested || shaking) {
            this.head.f_104205_ = (interested ? dog.m_30448_(partialTicks1) : 0.0f) + (shaking ? dog.m_30432_(partialTicks1, 0.0f) : 0.0f);
        }
        if (shaking) {
            this.upperBody.f_104205_ = dog.m_30432_(partialTicks1, -0.08f);
            this.body.f_104205_ = dog.m_30432_(partialTicks1, -0.16f);
            this.tail.f_104205_ = dog.m_30432_(partialTicks1, -0.2f);
        }
    }

    private void animateHeadLookTarget(float yRot, float xRot) {
        this.head.f_104203_ = xRot * ((float)Math.PI / 180);
        this.head.f_104204_ = yRot * ((float)Math.PI / 180);
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

