/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.foliage;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.zepalesque.redux.util.level.WorldgenUtil;
import net.zepalesque.redux.world.tree.foliage.ReduxFoliagePlacers;

public class BlightwillowFoliagePlacer
extends FoliagePlacer {
    public static final Codec<BlightwillowFoliagePlacer> CODEC = RecordCodecBuilder.create(p2 -> BlightwillowFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)p2).apply((Applicative)p2, BlightwillowFoliagePlacer::new));

    public BlightwillowFoliagePlacer(IntProvider rad, IntProvider offs) {
        super(rad, offs);
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)ReduxFoliagePlacers.BLIGHTWILLOW.get();
    }

    protected void m_213633_(LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int i1, FoliagePlacer.FoliageAttachment foliageAttachment, int foliageMaxHeight, int i2, int i3) {
        BlockPos blockpos = foliageAttachment.m_161451_();
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        this.generateLeaves(mbp, levelSimulatedReader, blockpos, foliageSetter, randomSource, treeConfiguration);
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 2;
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }

    private void generateLeaves(BlockPos.MutableBlockPos mutable, LevelSimulatedReader level, BlockPos origin, BiConsumer<BlockPos, BlockState> setter, RandomSource rand, TreeConfiguration config) {
        mutable.m_122190_((Vec3i)origin);
        BlockPos center = origin.m_6625_(3);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            mutable.m_122159_((Vec3i)center, d);
            BlockPos imm = mutable.m_7949_();
            BlightwillowFoliagePlacer.tryPlaceLog(level, setter, rand, config, imm, d.m_122434_());
            mutable.m_122159_((Vec3i)imm, d);
            BlightwillowFoliagePlacer.tryPlaceLog(level, setter, rand, config, mutable.m_7949_(), d.m_122434_());
        }
        int extend = 3;
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 3; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    int add = Mth.m_14040_((int)x) + Mth.m_14040_((int)y) + Mth.m_14040_((int)z);
                    if (add > extend) continue;
                    mutable.m_122154_((Vec3i)center, x, y, z);
                    BlightwillowFoliagePlacer.m_225622_((LevelSimulatedReader)level, setter, (RandomSource)rand, (TreeConfiguration)config, (BlockPos)mutable.m_7949_());
                }
            }
        }
        int layer1Height = 3;
        int layer2Height = 4;
        for (Direction d : Direction.Plane.HORIZONTAL) {
            int i;
            BlockPos start = center.m_5484_(d, extend);
            for (i = 0; i < layer1Height; ++i) {
                mutable.m_122154_((Vec3i)start, 0, i, 0);
                BlightwillowFoliagePlacer.m_225622_((LevelSimulatedReader)level, setter, (RandomSource)rand, (TreeConfiguration)config, (BlockPos)mutable.m_7949_());
            }
            for (i = 1; i < layer2Height + 1; ++i) {
                mutable.m_122154_((Vec3i)start, d.m_122429_(), i, d.m_122431_());
                BlightwillowFoliagePlacer.m_225622_((LevelSimulatedReader)level, setter, (RandomSource)rand, (TreeConfiguration)config, (BlockPos)mutable.m_7949_());
            }
        }
    }

    protected static boolean tryPlaceLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> foliageSetter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos, Direction.Axis axis) {
        if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = WorldgenUtil.trySetValue(treeConfiguration.f_68185_.m_213972_(random, pos), RotatedPillarBlock.f_55923_, axis);
        foliageSetter.accept(pos, blockstate);
        return true;
    }
}

