/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.misc.ReduxTags;
import net.zepalesque.redux.util.level.WorldgenUtil;

public class CloudcapFeature
extends Feature<Config> {
    public CloudcapFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        int totalheight = ((Config)context.m_159778_()).height.m_214085_(context.m_225041_());
        HashMap<BlockPos, BlockState> toPlace = new HashMap<BlockPos, BlockState>();
        HashMap roots = new HashMap();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos origin = context.m_159777_();
        if (context.m_159774_().m_7433_(origin.m_7495_(), state -> !CloudcapFeature.m_159759_((BlockState)state))) {
            return false;
        }
        for (int i = 0; i < totalheight; ++i) {
            mutable.m_122154_((Vec3i)origin, 0, i, 0);
            BlockPos immutable1 = mutable.m_7949_();
            toPlace.putIfAbsent(immutable1, ((Config)context.m_159778_()).stem.m_213972_(context.m_225041_(), immutable1));
        }
        for (Direction d : Direction.Plane.HORIZONTAL) {
            int i;
            HashMap<BlockPos, BlockState> stem = new HashMap<BlockPos, BlockState>();
            int rootHeight = ((Config)context.m_159778_()).rootHeight.m_214085_(context.m_225041_());
            int rootWallHeight = ((Config)context.m_159778_()).rootWallHeight.m_214085_(context.m_225041_());
            for (i = 0; i < rootHeight; ++i) {
                mutable.m_122154_((Vec3i)origin, d.m_122429_(), i, d.m_122431_());
                BlockPos immutable1 = mutable.m_7949_();
                stem.putIfAbsent(immutable1, ((Config)context.m_159778_()).stem.m_213972_(context.m_225041_(), immutable1));
            }
            for (i = -1; i > -5; --i) {
                mutable.m_122154_((Vec3i)origin, d.m_122429_(), i, d.m_122431_());
                BlockPos immutable2 = mutable.m_7949_();
                mutable.m_122154_((Vec3i)origin, 0, i, 0);
                BlockPos immutable3 = mutable.m_7949_();
                if (!context.m_159774_().m_7433_(immutable2, state -> state.m_60795_() || state.m_60767_().m_76336_()) || !context.m_159774_().m_7433_(immutable3, state -> state.m_60783_((BlockGetter)context.m_159774_(), immutable3, d))) break;
                stem.putIfAbsent(immutable2, ((Config)context.m_159778_()).stem.m_213972_(context.m_225041_(), immutable2));
            }
            BlockPos wallOrigin = origin.m_6630_(rootHeight);
            for (int i2 = 0; i2 < rootWallHeight; ++i2) {
                mutable.m_122154_((Vec3i)wallOrigin, d.m_122429_(), i2, d.m_122431_());
                BlockPos immutable1 = mutable.m_7949_();
                BlockState b = ((Config)context.m_159778_()).stemWall.m_213972_(context.m_225041_(), immutable1);
                b = this.trySet(b, WorldgenUtil.getWallSide(d.m_122424_()), i2 == rootWallHeight - 1 ? WallSide.LOW : WallSide.TALL);
                stem.putIfAbsent(immutable1, b);
            }
            roots.put(d, stem);
        }
        BlockPos stemTop = origin.m_6630_(totalheight - 1);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 0; ++y) {
                    if (x == 0 && z == 0) continue;
                    mutable.m_122154_((Vec3i)stemTop, x, y, z);
                    BlockPos immutable1 = mutable.m_7949_();
                    toPlace.putIfAbsent(immutable1, ((Config)context.m_159778_()).spore.m_213972_(context.m_225041_(), immutable1));
                }
            }
        }
        BlockPos capTop = origin.m_6630_(totalheight);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                mutable.m_122154_((Vec3i)capTop, x, 0, z);
                BlockPos immutable1 = mutable.m_7949_();
                toPlace.putIfAbsent(immutable1, ((Config)context.m_159778_()).cap.m_213972_(context.m_225041_(), immutable1));
            }
        }
        int capHeight = ((Config)context.m_159778_()).capHeight.m_214085_(context.m_225041_());
        int innerRadius = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y >= -capHeight; --y) {
                for (int z = -2; z <= 2; ++z) {
                    boolean outer;
                    boolean xEdges = x == -2 || x == 2;
                    boolean zEdges = z == -2 || z == 2;
                    boolean bl = outer = xEdges && !zEdges || !xEdges && zEdges;
                    if (!outer) continue;
                    mutable.m_122154_((Vec3i)capTop, x, y, z);
                    BlockPos immutable1 = mutable.m_7949_();
                    BlockState state2 = ((Config)context.m_159778_()).cap.m_213972_(context.m_225041_(), immutable1);
                    if (state2.m_61138_((Property)HugeMushroomBlock.f_54130_) && state2.m_61138_((Property)HugeMushroomBlock.f_54128_) && state2.m_61138_((Property)HugeMushroomBlock.f_54127_) && state2.m_61138_((Property)HugeMushroomBlock.f_54129_) && state2.m_61138_((Property)HugeMushroomBlock.f_54131_)) {
                        state2 = (BlockState)((BlockState)((BlockState)((BlockState)state2.m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(x < -innerRadius))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(x > innerRadius))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(z < -innerRadius))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(z > innerRadius));
                    }
                    if (y < -1 && state2.m_61138_((Property)HugeMushroomBlock.f_54131_)) {
                        state2 = (BlockState)state2.m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false));
                    }
                    toPlace.putIfAbsent(immutable1, state2);
                }
            }
        }
        for (Map.Entry entry : toPlace.entrySet()) {
            if (this.canPlaceBlockHere((LevelAccessor)context.m_159774_(), (BlockPos)entry.getKey())) continue;
            return false;
        }
        for (Map.Entry entry : toPlace.entrySet()) {
            this.m_5974_((LevelWriter)context.m_159774_(), (BlockPos)entry.getKey(), (BlockState)entry.getValue());
        }
        if (((Boolean)ReduxConfig.COMMON.wall_roots.get()).booleanValue()) {
            for (Direction d : Direction.Plane.HORIZONTAL) {
                if (!roots.containsKey(d)) continue;
                Map map = (Map)roots.get(d);
                boolean flag = false;
                for (Map.Entry entry : map.entrySet()) {
                    if (this.canPlaceBlockHere((LevelAccessor)context.m_159774_(), (BlockPos)entry.getKey())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                for (Map.Entry entry : map.entrySet()) {
                    this.m_5974_((LevelWriter)context.m_159774_(), (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                }
            }
        }
        return true;
    }

    private <E extends Comparable<E>> BlockState trySet(BlockState b, Property<E> prop, E val) {
        return b.m_61138_(prop) ? (BlockState)b.m_61124_(prop, val) : b;
    }

    protected boolean canPlaceBlockHere(LevelAccessor level, BlockPos pos) {
        int i = pos.m_123342_();
        if (i >= level.m_141937_() + 1 && i + 1 < level.m_151558_()) {
            return level.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13106_) || state.m_60767_().m_76336_() || state.m_204336_(ReduxTags.Blocks.MUSHROOM_CAPS));
        }
        return false;
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(mushroom -> mushroom.group((App)BlockStateProvider.f_68747_.fieldOf("cap_provider").forGetter(config -> config.cap), (App)BlockStateProvider.f_68747_.fieldOf("spore_provider").forGetter(config -> config.spore), (App)BlockStateProvider.f_68747_.fieldOf("stem_provider").forGetter(config -> config.stem), (App)BlockStateProvider.f_68747_.fieldOf("stem_wall_provider").forGetter(config -> config.stemWall), (App)IntProvider.f_146531_.fieldOf("height").forGetter(config -> config.height), (App)IntProvider.f_146531_.fieldOf("root_height").forGetter(config -> config.rootHeight), (App)IntProvider.f_146531_.fieldOf("root_wall_height").forGetter(config -> config.rootWallHeight), (App)IntProvider.f_146531_.fieldOf("cap_height").forGetter(config -> config.capHeight)).apply((Applicative)mushroom, Config::new));
        public final BlockStateProvider cap;
        public final BlockStateProvider spore;
        public final BlockStateProvider stem;
        public final BlockStateProvider stemWall;
        public final IntProvider height;
        public final IntProvider rootHeight;
        public final IntProvider rootWallHeight;
        public final IntProvider capHeight;

        public Config(BlockStateProvider cap, BlockStateProvider spore, BlockStateProvider stem, BlockStateProvider stemWall, IntProvider height, IntProvider rootHeight, IntProvider rootWallHeight, IntProvider capHeight) {
            this.cap = cap;
            this.spore = spore;
            this.stem = stem;
            this.stemWall = stemWall;
            this.height = height;
            this.rootHeight = rootHeight;
            this.rootWallHeight = rootWallHeight;
            this.capHeight = capHeight;
        }
    }
}

