/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.BiomeSpecialEffectsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.util.codec.ReduxCodecs;
import net.zepalesque.redux.util.holder.RegistryMap;

public record FoliageModifier(Optional<DefaultFoliageSettings> settings, RegistryMap<Biome, Integer> grassMap, RegistryMap<Biome, Integer> foliageMap) implements BiomeModifier
{
    public static final Codec<FoliageModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DefaultFoliageSettings.CODEC.optionalFieldOf("default_colors").forGetter(FoliageModifier::settings), (App)ReduxCodecs.MAP_CODEC.fieldOf("grass_map").forGetter(FoliageModifier::grassMap), (App)ReduxCodecs.MAP_CODEC.fieldOf("foliage_map").forGetter(FoliageModifier::foliageMap)).apply((Applicative)builder, FoliageModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING && (this.settings.isEmpty() || this.settings.get().biomes.m_203333_(biome))) {
            if (this.settings.isPresent()) {
                this.settings.get().grass.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48045_(arg_0));
                this.settings.get().foliage.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48043_(arg_0));
            }
            this.grassMap.get(biome).ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48045_(arg_0));
            this.foliageMap.get(biome).ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)builder.getSpecialEffects()).m_48043_(arg_0));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    public record DefaultFoliageSettings(HolderSet<Biome> biomes, Optional<Integer> grass, Optional<Integer> foliage) {
        public static final Codec<DefaultFoliageSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(DefaultFoliageSettings::biomes), (App)Codec.INT.optionalFieldOf("grass").forGetter(DefaultFoliageSettings::grass), (App)Codec.INT.optionalFieldOf("foliage").forGetter(DefaultFoliageSettings::foliage)).apply((Applicative)builder, DefaultFoliageSettings::new));
    }
}

