/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util.holder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.LazyOptional;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.util.holder.RegistryMapCodec;

public interface RegistryMap<K, V> {
    public static <K, V> Codec<RegistryMap<K, V>> codec(ResourceKey<? extends Registry<K>> registry, Codec<V> valueCodec) {
        return new RegistryMapCodec(registry, valueCodec);
    }

    public Map<Either<TagKey<K>, ResourceKey<K>>, V> encodeMap();

    public LazyOptional<Map<ResourceKey<K>, V>> keyMap();

    public LazyOptional<Map<Holder<K>, V>> holderMap();

    default public Map<Holder<K>, V> holderMapOrThrow() {
        return (Map)this.holderMap().orElseThrow(RegistryMap::exception);
    }

    default public V getOrThrow(Holder<K> key) {
        Preconditions.checkState((boolean)this.containsKey(key), (String)"RegistryMap does not contain value {}!", key);
        return ((Map)this.holderMap().orElseThrow(RegistryMap::exception)).get(key);
    }

    default public Optional<V> get(Holder<K> key) {
        return this.containsKey(key) ? Optional.of(this.getOrThrow(key)) : Optional.empty();
    }

    default public boolean containsKey(Holder<K> holder) {
        return this.holderMap().map(map -> map.containsKey(holder)).orElse(false) != false || this.keyMap().map(map -> holder.m_203543_().map(map::containsKey).orElse(false)).orElse(false) != false;
    }

    default public boolean containsValue(V val) {
        return this.holderMap().map(map -> map.containsValue(val)).orElse(false) != false || this.encodeMap().containsValue(val);
    }

    public Registered<K, V> asRegistered();

    public static <K, V> Keyed<K, V> createPartial(Map<Either<TagKey<K>, ResourceKey<K>>, V> encodeMap, Registry<K> getter) {
        return new Keyed<K, V>(encodeMap, getter);
    }

    public static <K, V> Registered<K, V> createFull(Map<Either<TagKey<K>, ResourceKey<K>>, V> encodeMap, Registry<K> lookup) {
        return new Registered<K, V>(encodeMap, lookup);
    }

    private static RuntimeException exception() {
        return new NoSuchElementException("No value present");
    }

    public static <K, V> Map<ResourceKey<K>, V> createKeyMap(Registry<K> registry, Map<Either<TagKey<K>, ResourceKey<K>>, V> keys) {
        HashMap map = new HashMap();
        Set<Map.Entry<Either<TagKey<K>, ResourceKey<K>>, V>> entrySet = keys.entrySet();
        Set<Pair> tagValues = entrySet.stream().filter(entry -> (Boolean)((Either)entry.getKey()).map(tag -> true, rk -> false)).map(entry -> Pair.of((Object)((TagKey)((Either)entry.getKey()).left().orElseThrow()), entry.getValue())).collect(Collectors.toSet());
        Set<Pair> keyValues = entrySet.stream().filter(entry -> (Boolean)((Either)entry.getKey()).map(tag -> false, rk -> true)).map(entry -> Pair.of((Object)((ResourceKey)((Either)entry.getKey()).right().orElseThrow()), entry.getValue())).collect(Collectors.toSet());
        tagValues.forEach(pair -> registry.m_203431_((TagKey)pair.getFirst()).ifPresent(set -> set.m_203614_().forEach(holder -> holder.m_203543_().ifPresent(key -> {
            if (map.containsKey(key)) {
                RegistryMap.logExistingFromTag(key, (TagKey)pair.getFirst(), map.get(key), pair.getSecond());
            }
            map.put(key, pair.getSecond());
        }))));
        keyValues.forEach(pair -> {
            ResourceKey key = (ResourceKey)pair.getFirst();
            if (map.containsKey(key)) {
                RegistryMap.logExisting(key, map.get(key), pair.getSecond());
            }
            map.put(key, pair.getSecond());
        });
        return ImmutableMap.copyOf(map);
    }

    private static <K, V> void logExistingFromTag(ResourceKey<K> key, TagKey<K> tag, V oldVal, V newVal) {
        Redux.LOGGER.warn("Found already existing holder {} from tag {}! Replacing value anyway! Old value was {}, new is {}", new Object[]{key.m_135782_(), tag.f_203868_(), oldVal, newVal});
    }

    private static <K, V> void logExisting(ResourceKey<K> key, V oldVal, V newVal) {
        Redux.LOGGER.warn("Found already existing holder {}! Replacing value anyway! Old value was {}, new is {}", new Object[]{key.m_135782_(), oldVal, newVal});
    }

    public static class Keyed<K, V>
    implements RegistryMap<K, V> {
        protected final Map<Either<TagKey<K>, ResourceKey<K>>, V> encodeMap;
        protected final LazyOptional<Map<ResourceKey<K>, V>> keyMap;
        protected final Registry<K> getter;

        private Keyed(Map<Either<TagKey<K>, ResourceKey<K>>, V> encodeMap, Registry<K> getter) {
            this.encodeMap = encodeMap;
            this.getter = getter;
            this.keyMap = LazyOptional.of(() -> RegistryMap.createKeyMap(getter, encodeMap));
        }

        @Override
        public Map<Either<TagKey<K>, ResourceKey<K>>, V> encodeMap() {
            return this.encodeMap;
        }

        @Override
        public LazyOptional<Map<ResourceKey<K>, V>> keyMap() {
            return this.keyMap;
        }

        @Override
        public LazyOptional<Map<Holder<K>, V>> holderMap() {
            return LazyOptional.empty();
        }

        @Override
        public Registered<K, V> asRegistered() {
            return new Registered<K, V>(this.encodeMap, this.getter);
        }
    }

    public static class Registered<K, V>
    extends Keyed<K, V> {
        private final LazyOptional<Map<Holder<K>, V>> holderMap;

        private Registered(Map<Either<TagKey<K>, ResourceKey<K>>, V> keyMap, Registry<K> lookup) {
            super(keyMap, lookup);
            this.holderMap = this.keyMap.lazyMap(keys -> keys.entrySet().stream().flatMap(entry -> Stream.ofNullable(lookup.m_203636_((ResourceKey)entry.getKey()).map(holder -> Pair.of((Object)holder, entry.getValue())).orElse(null))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }

        @Override
        public LazyOptional<Map<Holder<K>, V>> holderMap() {
            return this.holderMap;
        }

        @Override
        public Map<Holder<K>, V> holderMapOrThrow() {
            return (Map)this.holderMap().orElseThrow(RegistryMap::exception);
        }

        @Override
        public Registered<K, V> asRegistered() {
            return this;
        }
    }

    public static class Builder<K, V> {
        private final ImmutableMap.Builder<Either<TagKey<K>, ResourceKey<K>>, V> builder;

        private Builder(ImmutableMap.Builder<Either<TagKey<K>, ResourceKey<K>>, V> builder) {
            this.builder = builder;
        }

        public static <K, V> Builder<K, V> create() {
            return new Builder<K, V>(new ImmutableMap.Builder());
        }

        public Builder<K, V> put(TagKey<K> key, V value) {
            this.builder.put((Object)Either.left(key), value);
            return this;
        }

        public Builder<K, V> put(ResourceKey<K> key, V value) {
            this.builder.put((Object)Either.right(key), value);
            return this;
        }

        public RegistryMap<K, V> full(Registry<K> lookup) {
            return RegistryMap.createFull(this.builder.build(), lookup);
        }

        public RegistryMap<K, V> build(Registry<K> getter) {
            return RegistryMap.createPartial(this.builder.build(), getter);
        }
    }
}

