/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.mixin.common.entity;

import com.aetherteam.aether.entity.monster.Swet;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.event.hook.SwetHooks;
import net.zepalesque.redux.mixin.common.entity.SlimeMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Swet.class})
public abstract class SwetMixin
extends SlimeMixin {
    @Shadow
    private boolean wasOnGround;
    @Unique
    private static final EntityDimensions redux$dimensions = EntityDimensions.m_20395_((float)2.04f, (float)2.04f);

    @Shadow
    public abstract float getWaterDamageScale();

    @Override
    @Shadow
    public abstract int m_33632_();

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract void m_7839_(int var1, boolean var2);

    @Override
    protected void redux$doPush(Entity entity, CallbackInfo ci) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            ci.cancel();
        } else {
            super.redux$doPush(entity, ci);
        }
    }

    @WrapOperation(method={"createMobAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;createMobAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;")})
    private static AttributeSupplier.Builder attributes(Operation<AttributeSupplier.Builder> original) {
        return ((AttributeSupplier.Builder)original.call(new Object[0])).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22282_, 0.0);
    }

    @Inject(method={"getPassengersRidingOffset"}, at={@At(value="HEAD")}, cancellable=true)
    public void redux$offset(CallbackInfoReturnable<Double> cir) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            cir.setReturnValue((Object)((double)this.m_6972_((Pose)Pose.STANDING).f_20378_ * 0.75));
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void redux$interact(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            ItemStack i = player.m_21120_(hand);
            if (SwetHooks.canGrow((Swet)this, i)) {
                if (!player.m_7500_()) {
                    i.m_41774_(1);
                }
                this.m_7839_(this.m_33632_() + 1, false);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
            if (!SwetHooks.canBeControlled((Swet)this)) {
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void redux$tick(CallbackInfo ci) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue() && this.m_20096_() && !this.wasOnGround) {
            double i = SwetHooks.getTrueScale((Swet)this);
            ParticleOptions particle = SwetHooks.getSquelchParticles((Swet)this);
            if (particle != null) {
                int j = 0;
                while ((double)j < i * 8.0) {
                    float f = ((Swet)this).m_217043_().m_188501_() * ((float)Math.PI * 2);
                    float f1 = ((Swet)this).m_217043_().m_188501_() * 0.5f + 0.5f;
                    float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
                    float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
                    ((Swet)this).f_19853_.m_7106_(particle, ((Swet)this).m_20185_() + (double)f2, ((Swet)this).m_20186_(), ((Swet)this).m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                    ++j;
                }
            }
        }
    }

    @Inject(method={"getMountJumpStrength"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getMountJumpStrength(CallbackInfoReturnable<Double> cir) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            cir.setReturnValue((Object)(SwetHooks.getTrueScale((Swet)this) * 0.25));
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void redux$getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            cir.setReturnValue((Object)redux$dimensions.m_20388_(0.255f * (float)SwetHooks.getTrueScale((Swet)this)));
        }
    }

    @Inject(method={"canSpawnSplashParticles"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void redux$canSpawnSplashParticles(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setSize"}, at={@At(value="HEAD")})
    protected void redux$setSize(int size, boolean resetHealth, CallbackInfo ci) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            int i = Mth.m_14045_((int)size, (int)1, (int)127);
            this.f_19804_.m_135381_(f_33582_, (Object)i);
            this.m_20090_();
            this.m_6210_();
            this.m_21051_(Attributes.f_22276_).m_22100_((double)(i * i));
            this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.3f + 0.05f * (float)i));
            this.m_21051_(Attributes.f_22281_).m_22100_((double)i * 0.5);
            if (resetHealth) {
                this.m_21153_(this.m_21233_());
            }
            this.f_21364_ = i;
        }
    }

    @Inject(method={"getSize"}, at={@At(value="RETURN")}, cancellable=true)
    protected void redux$getSize(CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            cir.setReturnValue((Object)((Integer)this.f_19804_.m_135370_(f_33582_)));
        }
    }

    @Override
    protected void redux$finalize(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
    }

    @Override
    protected void redux$isPushable(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
            cir.setReturnValue((Object)false);
        } else {
            super.redux$isPushable(cir);
        }
    }
}

