/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.item.weapons;

import com.aetherteam.aether.entity.projectile.dart.AbstractDart;
import com.aetherteam.aether.item.combat.DartShooterItem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.item.tools.VeridiumItem;
import net.zepalesque.redux.item.util.TooltipUtils;
import org.jetbrains.annotations.Nullable;

public class VeridiumDartShooter
extends DartShooterItem
implements VeridiumItem {
    private final Supplier<? extends Item> uninfused;
    private final int useTime;

    public VeridiumDartShooter(Supplier<? extends Item> dartType, int useTime, Item.Properties properties, Supplier<? extends Item> uninfused) {
        super(dartType, properties);
        this.uninfused = uninfused;
        this.useTime = useTime;
    }

    @Override
    public Item getUninfusedItem(ItemStack stack) {
        return this.uninfused.get();
    }

    public int m_8105_(ItemStack stack) {
        return this.useTime;
    }

    public AbstractDart customDart(AbstractDart dart) {
        AbstractDart newDart = (AbstractDart)((EntityType)ReduxEntityTypes.INFUSED_VERIDIUM_DART.get()).m_20615_(dart.m_9236_());
        if (newDart != null && dart.m_37282_() != null) {
            Entity owner = dart.m_37282_();
            newDart.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
            newDart.m_5602_(owner);
            return newDart;
        }
        return super.customDart(dart);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        ItemStack original = super.m_5922_(stack, level, user);
        ItemStack transform = this.deplete(original, user, 1);
        if (!user.m_9236_().m_5776_() && transform != null && transform != original && user instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)user;
            this.sendSound(sp);
        }
        return transform == null ? original : transform;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag advanced) {
        MutableComponent infusion = Component.m_237110_((String)"tooltip.aether_redux.infusion_charge", (Object[])new Object[]{stack.m_41783_() == null ? (byte)0 : stack.m_41783_().m_128445_("infusion_level")}).m_130940_(ChatFormatting.GRAY);
        tooltips.add((Component)infusion);
        Component info = (Component)TooltipUtils.TOOLTIP_SHIFT_FOR_INFO.apply((Component)Component.m_237115_((String)"gui.aether_redux.infusion_info"));
        tooltips.add(info);
        super.m_7373_(stack, level, tooltips, advanced);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, amount, entity, onBroken) * 4;
    }

    public static class Uninfused
    extends DartShooterItem {
        private final int useTime;

        public Uninfused(Supplier<? extends Item> dartType, int useTime, Item.Properties properties) {
            super(dartType, properties);
            this.useTime = useTime;
        }

        public int m_8105_(ItemStack stack) {
            return this.useTime;
        }

        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag advanced) {
            Component info = (Component)TooltipUtils.TOOLTIP_SHIFT_FOR_INFO.apply((Component)Component.m_237115_((String)"gui.aether_redux.infusion_info"));
            tooltips.add(info);
            super.m_7373_(stack, level, tooltips, advanced);
        }
    }
}

