/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.item.weapons;

import com.aetherteam.aether.effect.AetherEffects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.client.render.ReduxRenderers;
import net.zepalesque.redux.entity.projectile.ThrownSpear;

public class BlightSpearItem
extends Item
implements Vanishable {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public BlightSpearItem(Item.Properties properties, double damage, double speed) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", damage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", speed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ReduxRenderers.itemProp);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 10 && !level.f_46443_) {
                stack.m_41622_(1, (LivingEntity)player, contextEntity -> contextEntity.m_21190_(entityLiving.m_7655_()));
                ThrownSpear spear = new ThrownSpear(level, (LivingEntity)player, stack);
                spear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
                if (player.m_150110_().f_35937_) {
                    spear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.m_7967_((Entity)spear);
                level.m_6269_(null, (Entity)spear, (SoundEvent)ReduxSoundEvents.SPEAR_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    player.m_150109_().m_36057_(stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, contextEntity -> contextEntity.m_21166_(EquipmentSlot.MAINHAND));
        if (!target.f_19853_.m_5776_() && target.f_19853_.m_213780_().m_188503_(3) == 0) {
            target.m_7292_(new MobEffectInstance(BlightSpearItem.getEffect(), 300));
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.m_60800_((BlockGetter)level, pos) != 0.0) {
            stack.m_41622_(2, entityLiving, contextEntity -> contextEntity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public static MobEffect getEffect() {
        return (MobEffect)AetherEffects.INEBRIATION.get();
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_ == EnchantmentCategory.WEAPON || enchantment == Enchantments.f_44955_;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 1;
    }
}

