/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.item.misc;

import com.google.common.base.Supplier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.Lazy;
import net.zepalesque.redux.item.util.TooltipUtils;
import org.jetbrains.annotations.Nullable;

public class LegacyBlockItem
extends BlockItem {
    private static final Component LEGACY = Component.m_237115_((String)"tooltip.aether_redux.legacy_item").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
    @Nullable
    private final Supplier<? extends ItemLike> replacement;
    @Nullable
    private final Supplier<? extends ItemLike> counterpart;
    private final Lazy<ItemStack> repStack;
    private final Lazy<ItemStack> counterStack;
    private final Lazy<Component> repMsg;
    private final Lazy<Component> counterMsg;

    private LegacyBlockItem(Block block, Item.Properties properties, @Nullable Supplier<? extends ItemLike> replacement, @Nullable Supplier<? extends ItemLike> counterpart) {
        super(block, properties);
        this.replacement = replacement;
        this.counterpart = counterpart;
        this.repStack = replacement == null ? null : () -> ((ItemLike)replacement.get()).m_5456_().m_7968_();
        this.counterStack = counterpart == null ? null : () -> ((ItemLike)counterpart.get()).m_5456_().m_7968_();
        this.repMsg = () -> this.repStack == null ? Component.m_237115_((String)"tooltip.aether_redux.legacy_deletion").m_130940_(ChatFormatting.GRAY) : Component.m_237110_((String)"tooltip.aether_redux.legacy_replacement", (Object[])new Object[]{LegacyBlockItem.name((ItemStack)this.repStack.get())}).m_130940_(ChatFormatting.GRAY);
        this.counterMsg = () -> this.counterStack == null ? null : Component.m_237110_((String)"tooltip.aether_redux.legacy_counterpart", (Object[])new Object[]{LegacyBlockItem.name((ItemStack)this.counterStack.get())}).m_130940_(ChatFormatting.GRAY);
    }

    public static LegacyBlockItem toDelete(Block block, Item.Properties properties) {
        return new LegacyBlockItem(block, properties, null, null);
    }

    public static LegacyBlockItem toDelete(Block block, Item.Properties properties, Supplier<? extends ItemLike> counterpart) {
        return new LegacyBlockItem(block, properties, null, counterpart);
    }

    public static LegacyBlockItem toReplace(Block block, Item.Properties properties, Supplier<? extends ItemLike> replacement) {
        return new LegacyBlockItem(block, properties, replacement, null);
    }

    public static LegacyBlockItem toReplace(Block block, Item.Properties properties, Supplier<? extends ItemLike> replacement, Supplier<? extends ItemLike> counterpart) {
        return new LegacyBlockItem(block, properties, replacement, counterpart);
    }

    private static Component name(ItemStack stack) {
        return stack.m_41786_().m_6881_().m_130938_(stack.m_41791_().getStyleModifier());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag advanced) {
        tooltips.add(LEGACY);
        tooltips.add((Component)TooltipUtils.TOOLTIP_SHIFT_FOR_INFO.apply((Component)this.repMsg.get()));
        Component other = (Component)TooltipUtils.TOOLTIP_HIDDEN_SHIFT_INFO.apply((Component)this.counterMsg.get());
        if (other != null) {
            tooltips.add(other);
        }
        super.m_7373_(stack, level, tooltips, advanced);
    }
}

