/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.event.hook;

import com.aetherteam.aether.entity.monster.Cockatrice;
import com.aetherteam.aether.entity.monster.dungeon.Mimic;
import com.aetherteam.aether.entity.monster.dungeon.Sentry;
import com.aetherteam.aether.entity.passive.Moa;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.zepalesque.redux.capability.animation.mimic.MimicAnimation;
import net.zepalesque.redux.capability.animation.moa.MoaAnimation;
import net.zepalesque.redux.capability.animation.sentry.SentryAnimation;
import net.zepalesque.redux.capability.cockatrice.CockatriceExtension;
import net.zepalesque.redux.capability.living.VampireAmulet;
import net.zepalesque.redux.capability.player.ReduxPlayer;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.entity.ai.goal.CockatriceMeleeAttackGoal;
import net.zepalesque.redux.entity.ai.goal.CockatriceRangedStrafeGoal;
import net.zepalesque.redux.entity.ai.target.HurtByOtherTypeTargetGoal;

public class MobHooks {
    public static void modifyCockatriceAI(Cockatrice cockatrice) {
        if (((Boolean)ReduxConfig.COMMON.cockatrice_burn_in_daylight.get()).booleanValue()) {
            cockatrice.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)cockatrice));
            cockatrice.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)cockatrice, 1.0));
        }
        cockatrice.f_21345_.m_25352_(1, (Goal)new CockatriceMeleeAttackGoal(cockatrice, 1.5, false));
        WrappedGoal[] toRemove = new WrappedGoal[1];
        WrappedGoal[] removeRanged = new WrappedGoal[1];
        cockatrice.f_21346_.m_148105_().forEach(goal -> {
            if (goal.m_26015_().getClass().equals(HurtByTargetGoal.class) && goal.m_26012_() == 1) {
                toRemove[0] = goal;
            }
        });
        if (toRemove[0] != null) {
            cockatrice.f_21346_.m_148105_().removeIf(wrappedGoal -> wrappedGoal == toRemove[0]);
            cockatrice.f_21346_.m_25352_(1, (Goal)new HurtByOtherTypeTargetGoal((PathfinderMob)cockatrice, new Class[0]));
        }
        cockatrice.f_21345_.m_25352_(1, (Goal)new CockatriceMeleeAttackGoal(cockatrice, 1.5, false));
        cockatrice.f_21345_.m_148105_().forEach(goal -> {
            if (goal.m_26015_().getClass().equals(RangedAttackGoal.class) && goal.m_26012_() == 2) {
                removeRanged[0] = goal;
            }
        });
        if (toRemove[0] != null) {
            cockatrice.f_21345_.m_148105_().removeIf(wrappedGoal -> wrappedGoal == removeRanged[0]);
            cockatrice.f_21345_.m_25352_(2, (Goal)new CockatriceRangedStrafeGoal(cockatrice, 1.0, 60, 10.0f));
        }
    }

    public static void modifyEntityQuicksoil(LivingEntity entity) {
        entity.m_20256_(entity.m_20184_().m_82542_(1.7, 1.0, 1.7));
        double maxMotion = 1.0;
        double x = Mth.m_14008_((double)entity.m_20184_().f_82479_, (double)-1.0, (double)1.0);
        double z = Mth.m_14008_((double)entity.m_20184_().f_82481_, (double)-1.0, (double)1.0);
        entity.m_20334_(x, entity.m_20184_().f_82480_, z);
    }

    public static void updateCapabilities(LivingEntity living) {
        if (living instanceof Cockatrice) {
            Cockatrice cockatrice = (Cockatrice)living;
            CockatriceExtension.get(cockatrice).ifPresent(CockatriceExtension::tick);
        }
        if (living instanceof Moa) {
            Moa moa = (Moa)living;
            if (moa.f_19853_.m_5776_()) {
                MoaAnimation.get(moa).ifPresent(MoaAnimation::tick);
            }
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            ReduxPlayer.get(player).ifPresent(ReduxPlayer::tick);
        }
        if (living instanceof Sentry) {
            Sentry sentry = (Sentry)living;
            if (sentry.f_19853_.m_5776_()) {
                SentryAnimation.get(sentry).ifPresent(SentryAnimation::tick);
            }
        }
        if (living instanceof Mimic) {
            Mimic mimic = (Mimic)living;
            if (mimic.f_19853_.m_5776_()) {
                MimicAnimation.get(mimic).ifPresent(MimicAnimation::tick);
            }
        }
        VampireAmulet.get(living).ifPresent(VampireAmulet::tick);
    }
}

