/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.entity.ai.goal.MykapodBreedGoal;
import net.zepalesque.redux.entity.ai.goal.MykapodLookGoal;
import net.zepalesque.redux.entity.ai.goal.MykapodPanicGoal;
import net.zepalesque.redux.entity.ai.goal.MykapodStareGoal;
import net.zepalesque.redux.entity.ai.goal.MykapodTemptGoal;
import net.zepalesque.redux.entity.ai.goal.MykapodWanderGoal;
import net.zepalesque.redux.entity.dataserializer.ReduxDataSerializers;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.misc.ReduxTags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Mykapod
extends AetherAnimal
implements IAnimatable {
    private final AnimationFactory cache = GeckoLibUtil.createFactory((IAnimatable)this);
    private int clientAnimTickCount = 0;
    private int sheddingTicker = 0;
    private static final EntityDataAccessor<Float> HURT_ANGLE = SynchedEntityData.m_135353_(Mykapod.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HURT_ANGLE_X = SynchedEntityData.m_135353_(Mykapod.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HURT_ANGLE_Z = SynchedEntityData.m_135353_(Mykapod.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<HideStatus> IS_HIDING = SynchedEntityData.m_135353_(Mykapod.class, (EntityDataSerializer)((EntityDataSerializer)ReduxDataSerializers.HIDE_STATUS.get()));
    private static final EntityDataAccessor<Boolean> HAS_SHELL = SynchedEntityData.m_135353_(Mykapod.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int hideCounter = 0;
    public int hideCooldown = 0;
    public int timeSinceShed = 0;
    @OnlyIn(value=Dist.CLIENT)
    public State anim;
    protected static final AnimationBuilder HIDDEN = new AnimationBuilder().loop("animations.mykapod.hidden");
    protected static final AnimationBuilder RUNAWAY = new AnimationBuilder().loop("animations.mykapod.runaway");
    protected static final AnimationBuilder MOVE = new AnimationBuilder().loop("animations.mykapod.move");
    protected static final AnimationBuilder IDLE = new AnimationBuilder().loop("animations.mykapod.idle");
    protected static final AnimationBuilder SCARED = new AnimationBuilder().playOnce("animations.mykapod.scared");
    protected static final AnimationBuilder HIDE = new AnimationBuilder().playOnce("animations.mykapod.hide");
    protected static final AnimationBuilder SHED = new AnimationBuilder().playOnce("animations.mykapod.shed");
    protected static final AnimationBuilder UNHIDE = new AnimationBuilder().playOnce("animations.mykapod.unhide");
    protected static final AnimationBuilder FORCE_UNHIDE = new AnimationBuilder().playOnce("animations.mykapod.force_unhide");

    public Mykapod(EntityType<? extends Mykapod> entityType, Level level) {
        super(entityType, level);
        this.m_6210_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MykapodPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new MykapodBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MykapodTemptGoal(this, 1.25, Ingredient.m_204132_(ReduxTags.Items.MYKAPOD_FOLLOW_ITEMS), false));
        this.f_21345_.m_25352_(5, (Goal)new MykapodWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new MykapodStareGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new MykapodLookGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22278_, 0.75);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_HIDING, (Object)HideStatus.OUT);
        this.m_20088_().m_135372_(HAS_SHELL, (Object)true);
        this.m_20088_().m_135372_(HURT_ANGLE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(HURT_ANGLE_X, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(HURT_ANGLE_Z, (Object)Float.valueOf(0.0f));
    }

    public boolean hasShell() {
        return (Boolean)this.m_20088_().m_135370_(HAS_SHELL);
    }

    public void setShell(boolean shell) {
        this.m_20088_().m_135381_(HAS_SHELL, (Object)shell);
    }

    public boolean isHiding() {
        return ((HideStatus)((Object)this.m_20088_().m_135370_(IS_HIDING))).isHidden();
    }

    public HideStatus hideStatus() {
        return (HideStatus)((Object)this.m_20088_().m_135370_(IS_HIDING));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            ++this.clientAnimTickCount;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_()) {
            if (this.hideCooldown > 0) {
                --this.hideCooldown;
            }
            if (this.sheddingTicker > 0) {
                --this.sheddingTicker;
            }
            if (this.sheddingTicker == 10) {
                this.shedShell();
            }
            if (this.sheddingTicker == 1) {
                this.setHiding(HideStatus.OUT);
            }
            if (this.sheddingTicker == 25) {
                this.shedAnim();
            }
            this.hideCounter = this.isHiding() && this.hideCounter > 1 ? --this.hideCounter : 0;
            if (this.isHiding() && this.hideCounter <= 0) {
                this.setHiding(HideStatus.OUT);
            }
            if (!this.hasShell()) {
                ++this.timeSinceShed;
                if (this.timeSinceShed > 3000 && this.f_19796_.m_188503_(this.timeSinceShed - 3000) > 150) {
                    this.setShell(true);
                    this.timeSinceShed = 0;
                }
            }
        }
    }

    public void setHiding(HideStatus hiding) {
        this.m_20088_().m_135381_(IS_HIDING, (Object)hiding);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == IS_HIDING) {
            this.m_6210_();
            if (this.f_19853_.m_5776_() && this.clientAnimTickCount > 1) {
                if (this.hideStatus() == HideStatus.OUT) {
                    this.anim = State.UNHIDE;
                } else if (this.hideStatus() == HideStatus.INTERRUPTED) {
                    this.anim = State.INTERRUPT;
                } else if (this.hideStatus() == HideStatus.SCARED) {
                    this.anim = State.FEAR;
                } else if (this.hideStatus() == HideStatus.HIDING) {
                    this.anim = State.HIDE;
                }
            }
        }
    }

    public float getHurtAngleX() {
        return ((Float)this.m_20088_().m_135370_(HURT_ANGLE_X)).floatValue();
    }

    public void setHurtAngleX(float hurtAngleX) {
        this.m_20088_().m_135381_(HURT_ANGLE_X, (Object)Float.valueOf(hurtAngleX));
    }

    public float getHurtAngleZ() {
        return ((Float)this.m_20088_().m_135370_(HURT_ANGLE_Z)).floatValue();
    }

    public void setHurtAngleZ(float hurtAngleZ) {
        this.m_20088_().m_135381_(HURT_ANGLE_Z, (Object)Float.valueOf(hurtAngleZ));
    }

    public float getHurtAngle() {
        return ((Float)this.m_20088_().m_135370_(HURT_ANGLE)).floatValue();
    }

    public void setHurtAngle(float hurtAngle) {
        this.m_20088_().m_135381_(HURT_ANGLE, (Object)Float.valueOf(hurtAngle));
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ReduxSoundEvents.MYKAPOD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ReduxSoundEvents.MYKAPOD_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_((SoundEvent)ReduxSoundEvents.MYKAPOD_MOVE.get(), 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.isHiding();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity entitySource = source.m_7639_();
        if (entitySource instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entitySource;
            if (source.m_19376_()) {
                if (this.isHiding()) {
                    this.setHiding(HideStatus.INTERRUPTED);
                    this.hideCounter = Math.max(this.hideCounter - 5, 0);
                    return super.m_6469_(source, amount);
                }
            } else {
                if (this.isHiding()) {
                    if (this.canAttackShell(attacker.m_21205_())) {
                        if (!this.breakShell(attacker)) {
                            this.crackShell();
                        }
                        this.setHiding(HideStatus.INTERRUPTED);
                        return super.m_6469_(source, amount);
                    }
                    this.hideCounter = Math.max(this.hideCounter - 5, 0);
                    this.wobbleAttack(entitySource);
                    return false;
                }
                if (!this.canAttackShell(attacker.m_21205_())) {
                    if (this.hideCooldown <= 0) {
                        this.setHiding(HideStatus.SCARED);
                        this.m_21573_().m_26573_();
                        this.hideCooldown = 900;
                        this.hideCounter = 240 + this.f_19796_.m_188503_(120);
                    }
                } else if (!this.breakShell(attacker)) {
                    this.crackShell();
                }
                return super.m_6469_(source, amount);
            }
        }
        return super.m_6469_(source, amount);
    }

    private void wobbleAttack(Entity attacker) {
        double c;
        double a = Math.abs(this.m_20182_().m_7096_() - attacker.m_20182_().m_7096_());
        if (a > (c = Math.abs(this.m_20182_().m_7094_() - attacker.m_20182_().m_7094_()))) {
            this.setHurtAngleZ(1.0f);
            this.setHurtAngleX(0.0f);
            if (this.m_20182_().m_7096_() > attacker.m_20182_().m_7096_()) {
                this.setHurtAngleZ(-1.0f);
            }
        } else {
            this.setHurtAngleX(1.0f);
            this.setHurtAngleZ(0.0f);
            if (this.m_20182_().m_7094_() > attacker.m_20182_().m_7094_()) {
                this.setHurtAngleX(-1.0f);
            }
        }
        this.setHurtAngle(0.7f - this.m_21223_() / 875.0f);
    }

    private void breakParticles(int count) {
        Level level;
        if (!this.f_19853_.m_5776_() && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            for (int j = 0; j < count; ++j) {
                double a = this.m_20191_().f_82288_ + (double)this.f_19796_.m_188501_() * (this.m_20191_().f_82291_ - this.m_20191_().f_82288_);
                double b = this.m_20191_().f_82289_ + (double)this.f_19796_.m_188501_() * (this.m_20191_().f_82292_ - this.m_20191_().f_82289_);
                double c = this.m_20191_().f_82290_ + (double)this.f_19796_.m_188501_() * (this.m_20191_().f_82293_ - this.m_20191_().f_82290_);
                sl.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ReduxItems.MYKAPOD_SHELL_CHUNK.get())), a, b, c, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected boolean canAttackShell(ItemStack stack) {
        return stack.canPerformAction(ToolActions.PICKAXE_DIG) || stack.m_204117_(AetherTags.Items.SLIDER_DAMAGING_ITEMS);
    }

    public boolean shedShell() {
        if (!this.f_19853_.m_5776_() && this.hasShell() && !this.m_6162_()) {
            this.breakParticles(10);
            this.setShell(false);
            this.m_20000_((ItemLike)ReduxItems.MYKAPOD_SHELL_CHUNK.get(), 1);
            this.f_19853_.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, (SoundEvent)ReduxSoundEvents.MYKAPOD_SHELL_SHED.get(), SoundSource.NEUTRAL, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            return true;
        }
        return false;
    }

    public void shedAnim() {
        if (!this.f_19853_.m_5776_()) {
            this.m_21573_().m_26573_();
            this.f_19853_.m_7605_((Entity)this, (byte)17);
        }
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 17 && this.f_19853_.m_5776_()) {
            this.anim = State.SHED;
        } else if (id == 16 && this.f_19853_.m_5776_()) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    public boolean breakShell(LivingEntity entity) {
        block2: {
            block4: {
                block3: {
                    if (this.f_19853_.m_5776_() || !this.hasShell() || this.m_6162_()) break block2;
                    if (!(entity instanceof Player)) break block3;
                    Player p = (Player)entity;
                    if (!(this.f_19796_.m_188501_() < p.m_36403_(0.0f))) break block2;
                    break block4;
                }
                if (!this.f_19796_.m_188499_()) break block2;
            }
            this.breakParticles(15);
            this.setShell(false);
            this.f_19853_.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, (SoundEvent)ReduxSoundEvents.MYKAPOD_SHELL_BREAK.get(), SoundSource.NEUTRAL, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            return true;
        }
        return false;
    }

    public void crackShell() {
        if (!this.f_19853_.m_5776_() && this.hasShell() && !this.m_6162_()) {
            this.breakParticles(5);
            this.f_19853_.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, (SoundEvent)ReduxSoundEvents.MYKAPOD_SHELL_CRACK.get(), SoundSource.NEUTRAL, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsHiding", this.isHiding());
        compound.m_128379_("HasShell", this.hasShell());
        compound.m_128405_("HideCounter", this.hideCounter);
        compound.m_128405_("HideCooldown", this.hideCooldown);
        compound.m_128405_("TimeSinceShed", this.timeSinceShed);
        compound.m_128405_("SheddingTicker", this.sheddingTicker);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("IsHiding")) {
            this.setHiding(compound.m_128471_("IsHiding") ? HideStatus.SCARED : HideStatus.OUT);
        }
        if (compound.m_128441_("HasShell")) {
            this.setShell(compound.m_128471_("HasShell"));
        }
        if (compound.m_128441_("HideCounter")) {
            this.hideCounter = compound.m_128451_("HideCounter");
        }
        if (compound.m_128441_("HideCooldown")) {
            this.hideCooldown = compound.m_128451_("HideCooldown");
        }
        if (compound.m_128441_("TimeSinceShed")) {
            this.timeSinceShed = compound.m_128451_("TimeSinceShed");
        }
        if (compound.m_128441_("SheddingTicker")) {
            this.sheddingTicker = compound.m_128451_("SheddingTicker");
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20390_(1.0f, this.isHiding() ? 0.5f : 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob entity) {
        return (AgeableMob)((EntityType)ReduxEntityTypes.MYKAPOD.get()).m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ReduxTags.Items.MYKAPOD_TEMPTATION_ITEMS) && !this.isHiding();
    }

    public boolean canUseToShed(ItemStack stack) {
        return stack.m_204117_(ReduxTags.Items.MYKAPOD_SHED_FOOD) && !this.isHiding();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.canUseToShed(itemstack) && !this.f_19853_.f_46443_ && !this.m_6162_() && this.hasShell()) {
            this.m_142075_(player, hand, itemstack);
            this.setHiding(HideStatus.HIDING);
            this.hideCounter = 50;
            this.sheddingTicker = 50;
            this.f_19853_.m_7605_((Entity)this, (byte)16);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void landAnim(String instructions) {
        BlockPos blockpos;
        BlockState blockstate;
        if (instructions.equals("land") && !(blockstate = this.f_19853_.m_8055_(blockpos = this.m_216999_())).addRunningEffects(this.f_19853_, blockpos, (Entity)this) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 vec3 = this.m_20184_();
            BlockPos blockpos1 = this.m_20183_();
            double d0 = this.m_20185_();
            double d1 = this.m_20189_();
            if (blockpos1.m_123341_() != blockpos.m_123341_()) {
                d0 = Mth.m_14008_((double)d0, (double)blockpos.m_123341_(), (double)((double)blockpos.m_123341_() + 1.0));
            }
            if (blockpos1.m_123343_() != blockpos.m_123343_()) {
                d1 = Mth.m_14008_((double)d1, (double)blockpos.m_123343_(), (double)((double)blockpos.m_123343_() + 1.0));
            }
            for (int i = 0; i < 10; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), d0, this.m_20186_() + 0.1, d1, vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
            }
            SoundType soundtype = blockstate.getSoundType((LevelReader)this.f_19853_, blockpos, (Entity)this);
            this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
        }
    }

    public void registerControllers(AnimationData registrar) {
        registrar.addAnimationController(new AnimationController((IAnimatable)this, "idle_anims", 3.0f, this::predicate));
        AnimationController anim = new AnimationController((IAnimatable)this, "other_anims", 3.0f, this::hiding);
        anim.registerCustomInstructionListener(event -> this.landAnim(event.instructions));
        registrar.addAnimationController(anim);
    }

    private <T extends IAnimatable> PlayState predicate(AnimationEvent<T> state) {
        if (this.isHiding()) {
            state.getController().setAnimation(HIDDEN);
            return PlayState.CONTINUE;
        }
        if (state.isMoving()) {
            Vec3 velocity = this.m_20184_();
            float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
            state.getController().setAnimation(avgVelocity > 0.01f ? RUNAWAY : MOVE);
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    private <T extends IAnimatable> PlayState hiding(AnimationEvent<T> state) {
        State current = this.anim;
        if (current == State.FEAR) {
            state.getController().setAnimation(SCARED);
            this.anim = State.NONE;
        } else if (current == State.HIDE) {
            state.getController().setAnimation(HIDE);
            this.anim = State.NONE;
        } else if (current == State.SHED) {
            state.getController().setAnimation(SHED);
            this.anim = State.NONE;
        } else if (current == State.UNHIDE && state.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            state.getController().setAnimation(UNHIDE);
            this.anim = State.NONE;
        } else if (current == State.INTERRUPT && state.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            state.getController().setAnimation(FORCE_UNHIDE);
            this.anim = State.NONE;
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.cache;
    }

    public static enum HideStatus implements StringRepresentable
    {
        SCARED(true, "scared"),
        HIDING(true, "hiding"),
        OUT(false, "out"),
        INTERRUPTED(false, "interrupted");

        private final boolean hidden;
        private final String id;

        private HideStatus(boolean b, String id) {
            this.hidden = b;
            this.id = id;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public String m_7912_() {
            return this.id;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static enum State {
        NONE,
        FEAR,
        HIDE,
        UNHIDE,
        INTERRUPT,
        SHED;

    }
}

