/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.model.entity;

import com.aetherteam.aether.entity.monster.dungeon.Mimic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.zepalesque.redux.capability.animation.mimic.MimicAnimation;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.util.math.EasingUtil;
import net.zepalesque.redux.util.math.MathUtil;

public class MimicReduxModel
extends EntityModel<Mimic> {
    private final ModelPart main;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart head;
    private final ModelPart lowerBody;
    private final ModelPart upperBody;

    public MimicReduxModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.leftLeg = this.main.m_171324_("leftLeg");
        this.rightLeg = this.main.m_171324_("rightLeg");
        this.head = this.main.m_171324_("head");
        this.lowerBody = this.head.m_171324_("lowerBody");
        this.upperBody = this.lowerBody.m_171324_("upperBody");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition main = partdefinition.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition leftLeg = main.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(30, 43).m_171488_(-4.0f, -2.5f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-9.5f, (float)0.0f));
        PartDefinition rightLeg = main.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(30, 43).m_171480_().m_171488_(-1.0f, -2.5f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)7.0f, (float)-9.5f, (float)0.0f));
        PartDefinition head = main.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.0f, (float)-22.0f, (float)-8.0f));
        PartDefinition lowerBody = head.m_171599_("lowerBody", CubeListBuilder.m_171558_().m_171514_(47, 31).m_171488_(-14.0f, 3.0f, 2.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth_r1 = lowerBody.m_171599_("mouth_r1", CubeListBuilder.m_171558_().m_171514_(-14, 43).m_171488_(-7.0f, 20.0f, -7.0f, 14.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 19).m_171488_(-7.0f, 11.0f, -7.0f, 14.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)27.0f, (float)8.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody = lowerBody.m_171599_("upperBody", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-14.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)7.0f, (float)15.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition teeth_lower_r1 = upperBody.m_171599_("teeth_lower_r1", CubeListBuilder.m_171558_().m_171514_(44, 7).m_171488_(-6.0f, -1.5f, -6.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)-1.5f, (float)7.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition knob = upperBody.m_171599_("knob", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -3.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)1.0f, (float)14.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Mimic mimic, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag = mimic.m_21256_() > 4;
        float partial = Minecraft.m_91087_().getPartialTick();
        float egg = 1.0f;
        if (flag) {
            egg = (float)mimic.m_20184_().m_82556_();
            egg /= 0.2f;
            egg *= egg * egg;
        }
        if (egg < 1.0f) {
            egg = 1.0f;
        }
        this.main.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / egg * 0.075f;
        float f = Math.max(ageInTicks, 1.0f) - 1.0f;
        float maxValue = 25.0f;
        float ticks = f % maxValue;
        float maxRot = 1.134464f;
        float rotation = ticks >= 10.0f ? (float)Math.PI - (maxRot - EasingUtil.Bounce.out((ticks - 10.0f) / 15.0f) * maxRot) : (float)Math.PI + MathUtil.costrp(ticks / 10.0f, (float)Math.PI * 2, (float)Math.PI * 2 - maxRot);
        this.upperBody.f_104203_ = rotation;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (ageInTicks <= 1.0f) {
            this.head.f_104201_ = -16.0f;
            this.leftLeg.f_104200_ = -2.0f;
            this.rightLeg.f_104200_ = 2.0f;
        } else {
            this.head.f_104201_ = -22.0f;
            this.leftLeg.f_104200_ = -7.0f;
            this.rightLeg.f_104200_ = 7.0f;
        }
        MimicAnimation.get(mimic).ifPresent(anim -> {
            if (anim.getOpenAnim() != 0 && anim.getPrevOpenAnim() != 0) {
                float prevAnim = anim.getPrevOpenAnim() == 0 && anim.getOpenAnim() > 1 ? 10.0f : (float)anim.getPrevOpenAnim();
                float progress = (10.0f - Mth.m_14179_((float)partial, (float)prevAnim, (float)anim.getOpenAnim())) / 10.0f;
                this.head.f_104201_ = -16.0f + -6.0f * EasingUtil.Back.inOut(progress);
                float progressLegs = Math.min(progress / 0.5f, 1.0f);
                float legX = 5.0f * EasingUtil.Back.out(progressLegs);
                this.leftLeg.f_104200_ = -2.0f - legX;
                this.rightLeg.f_104200_ = 2.0f + legX;
            }
        });
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (((Boolean)ReduxConfig.COMMON.smaller_mimic_hitbox.get()).booleanValue()) {
            this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

