/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.entity.projectile.Ember;

public class EmberRenderer
extends EntityRenderer<Ember> {
    private static final ResourceLocation TEXTURE_LOCATION = Redux.locate("textures/entity/ember.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)TEXTURE_LOCATION);

    public EmberRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Ember entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        int i = 10;
        int alpha = entity.lifetime - entity.f_19797_ < i ? (int)(255.0f * ((float)(entity.lifetime - entity.f_19797_) / (float)i)) : 255;
        int light = 0xF000F0;
        float size = 0.125f;
        float radius = size / 2.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)radius, 0.0);
        poseStack.m_85845_(this.f_114476_.m_114470_());
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_85861_();
        Matrix3f matrix3f = posestack$pose.m_85864_();
        VertexConsumer vertexconsumer = buffer.m_6299_(RENDER_TYPE);
        EmberRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, -radius, -radius, 0, 1, alpha);
        EmberRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, radius, -radius, 1, 1, alpha);
        EmberRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, radius, radius, 1, 0, alpha);
        EmberRenderer.vertex(vertexconsumer, matrix4f, matrix3f, light, -radius, radius, 0, 0, alpha);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, int lightmapUV, float x, float y, int u, int v) {
        EmberRenderer.vertex(consumer, pose, normal, lightmapUV, x, y, u, v, 255);
    }

    private static void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, int lightmapUV, float x, float y, int u, int v, int alpha) {
        consumer.m_85982_(pose, x, y, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmapUV).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(Ember entity) {
        return TEXTURE_LOCATION;
    }
}

