/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SparkParticle
extends TextureSheetParticle {
    SparkParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.f_107226_ = 1.0f;
        this.f_172258_ = 0.99f;
        this.f_107215_ *= (double)0.8f;
        this.f_107216_ *= (double)0.8f;
        this.f_107217_ *= (double)0.8f;
        this.f_107663_ = 0.125f;
        this.m_6569_(this.f_107223_.m_188501_() * 0.2f + 0.4f);
        this.f_107225_ = (int)(32.0 / (Math.random() * 0.6 + 0.4));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float pPartialTick) {
        return 0xF000F0;
    }

    public Vec3 bounceAxis(Vec3 velocity, Direction direction) {
        Direction.Axis axis = direction.m_122434_();
        double x = velocity.f_82479_;
        double y = velocity.f_82480_;
        double z = velocity.f_82481_;
        if (axis == Direction.Axis.X) {
            x = -x;
        } else if (axis == Direction.Axis.Y) {
            y = -y;
        } else if (axis == Direction.Axis.Z) {
            z = -z;
        }
        return new Vec3(x, y, z);
    }

    public void m_5989_() {
        Vec3 velocity = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_);
        Vec3 pos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        velocity = velocity.m_82542_(Math.abs(velocity.f_82479_) > 0.1 ? 1.0 : 0.0, Math.abs(velocity.f_82480_) > 0.1 ? 1.0 : 0.0, Math.abs(velocity.f_82481_) > 0.1 ? 1.0 : 0.0);
        HitResult hitresult = SparkParticle.getHitResult(pos, velocity.m_82553_() == 0.0 ? velocity.m_82520_(0.0, -0.04, 0.0) : velocity, (Level)this.f_107208_);
        if (velocity.m_82553_() > 0.0 && hitresult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 bounce = this.bounceAxis(velocity, ((BlockHitResult)hitresult).m_82434_());
            Vec3 scaled = bounce.m_82490_(0.5);
            this.f_107215_ = scaled.f_82479_;
            this.f_107216_ = scaled.f_82480_;
            this.f_107217_ = scaled.f_82481_;
            double x = hitresult.m_82450_().f_82479_;
            double y = hitresult.m_82450_().f_82480_;
            double z = hitresult.m_82450_().f_82481_;
            this.m_107264_(x, y, z);
            this.f_107226_ = 0.0f;
        } else {
            this.f_107226_ = 1.0f;
        }
        super.m_5989_();
        int i = 10;
        if (this.f_107225_ - this.f_107224_ < i) {
            this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)i;
        }
    }

    private static HitResult getHitResult(Vec3 startVec, Vec3 endVecOffset, Level level) {
        Vec3 vec3 = startVec.m_82549_(endVecOffset);
        return level.m_45547_(new ClipContext(startVec, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            SparkParticle particle = new SparkParticle(pLevel, pX, pY, pZ);
            particle.m_108335_(this.sprite);
            return particle;
        }
    }
}

