/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;

@OnlyIn(value=Dist.CLIENT)
public class CloudcapSporeParticle
extends TextureSheetParticle {
    private final Fluid type;
    protected boolean isGlowing;

    CloudcapSporeParticle(ClientLevel level, double x, double y, double z, Fluid type) {
        super(level, x, y, z);
        this.m_107250_(0.005f, 0.005f);
        this.f_107226_ = 0.06f;
        this.type = type;
    }

    protected Fluid getType() {
        return this.type;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float partialTick) {
        return this.isGlowing ? 240 : super.m_6355_(partialTick);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                BlockPos blockpos;
                FluidState fluidstate;
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                if (this.type != Fluids.f_76191_ && (fluidstate = this.f_107208_.m_6425_(blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_))).m_76152_() == this.type && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingParticle
    extends CloudcapSporeParticle {
        FallingParticle(ClientLevel level, double x, double y, double z, Fluid type) {
            this(level, x, y, z, type, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        FallingParticle(ClientLevel level, double x, double y, double z, Fluid type, int lifetime) {
            super(level, x, y, z, type);
            this.f_107225_ = lifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FallingSpore
    extends FallingParticle {
        protected final ParticleOptions landParticle;

        public FallingSpore(ClientLevel level, double x, double y, double z, Fluid type, ParticleOptions landParticle) {
            super(level, x, y, z, type);
            this.landParticle = landParticle;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LandingSpore
    extends CloudcapSporeParticle {
        LandingSpore(ClientLevel p_106102_, double p_106103_, double p_106104_, double p_106105_, Fluid p_106106_) {
            super(p_106102_, p_106103_, p_106104_, p_106105_, p_106106_);
            this.f_107225_ = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Landing
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Landing(SpriteSet spriteSetIn) {
            this.spriteSet = spriteSetIn;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LandingSpore dripparticle = new LandingSpore(level, x, y, z, Fluids.f_76191_);
            dripparticle.isGlowing = true;
            ((CloudcapSporeParticle)dripparticle).f_107225_ = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            dripparticle.m_108335_(this.spriteSet);
            return dripparticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Falling
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Falling(SpriteSet spriteSetIn) {
            this.spriteSet = spriteSetIn;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingSpore dripparticle = new FallingSpore(level, x, y, z, Fluids.f_76191_, (ParticleOptions)ReduxParticleTypes.LANDING_CLOUDCAP_SPORE.get());
            dripparticle.isGlowing = true;
            ((CloudcapSporeParticle)dripparticle).f_107226_ = 0.0025f;
            dripparticle.m_108335_(this.spriteSet);
            return dripparticle;
        }
    }
}

