/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.screen.menu;

import com.aetherteam.aether.client.gui.component.menu.AetherMenuButton;
import com.aetherteam.aether.client.gui.component.menu.DynamicMenuButton;
import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.gui.component.menu.ReduxMenuButton;

public class ReduxTitleScreen
extends TitleScreen
implements TitleScreenBehavior {
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation AETHER_LOGO = Redux.locate("textures/gui/title/redux.png");
    private final PanoramaRenderer cube;
    private int rows;
    private static final int baseLogoHeight = 144;
    private static final int SPLASH_COLOR = 0xAAAAFF;
    private static final int baseLogoWidth = 288;

    public ReduxTitleScreen(String panorama) {
        ((TitleScreenAccessor)this).aether$setFading(true);
        this.cube = new PanoramaRenderer(new CubeMap(Redux.locate("textures/gui/title/panorama/" + panorama + "/panorama")));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupButtons();
    }

    public void setupButtons() {
        int buttonRows = 0;
        boolean lastY = false;
        for (Widget renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget = (AbstractWidget)renderable;
            if (TitleScreenBehavior.isImageButton((Component)abstractWidget.m_6035_())) {
                abstractWidget.f_93624_ = false;
            }
            if (!(abstractWidget instanceof ReduxMenuButton)) continue;
            ReduxMenuButton aetherMenuButton = (ReduxMenuButton)abstractWidget;
            aetherMenuButton.buttonCountOffset = ++buttonRows;
        }
        this.rows = buttonRows;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)this;
        float fadeAmount = super.handleFading(poseStack, (TitleScreen)this, titleScreenAccessor, this.cube, PANORAMA_OVERLAY, partialTicks);
        float scale = ReduxTitleScreen.getScale(this, this.getMinecraft());
        this.setupLogo(poseStack, fadeAmount, scale);
        int roundedFadeAmount = Mth.m_14167_((float)(fadeAmount * 255.0f)) << 24;
        if ((roundedFadeAmount & 0xFC000000) != 0) {
            ForgeHooksClient.renderMainMenu((TitleScreen)this, (PoseStack)poseStack, (Font)this.f_96547_, (int)this.f_96543_, (int)this.f_96544_, (int)roundedFadeAmount);
            if (titleScreenAccessor.aether$getSplash() != null) {
                float splashX = (float)this.f_96543_ / 2.0f + 144.0f / scale;
                float splashY = (int)(20.0f + 120.0f / scale);
                poseStack.m_85836_();
                poseStack.m_85837_((double)splashX, (double)splashY, 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-20.0f));
                float textSize = 1.4f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                String splash = titleScreenAccessor.aether$getSplash();
                textSize = textSize * (200.0f / scale) / ((float)this.f_96547_.m_92895_(splash) + 64.0f / scale);
                poseStack.m_85841_(textSize, textSize, textSize);
                GuiComponent.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)splash, (int)0, (int)((int)(-16.0f / scale)), (int)(0xAAAAFF | roundedFadeAmount));
                poseStack.m_85849_();
            }
            super.renderRightBranding(poseStack, (TitleScreen)this, this.f_96547_, roundedFadeAmount);
        }
        int xOffset = super.handleButtonVisibility((TitleScreen)this, fadeAmount);
        for (Widget renderable : this.f_169369_) {
            renderable.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            if (renderable instanceof AetherMenuButton) {
                AetherMenuButton aetherButton = (AetherMenuButton)renderable;
                if (aetherButton.m_5953_((double)mouseX, (double)mouseY)) {
                    if (aetherButton.hoverOffset < 15) {
                        aetherButton.hoverOffset += 4;
                    }
                } else if (aetherButton.hoverOffset > 0) {
                    aetherButton.hoverOffset -= 4;
                }
            }
            if (!(renderable instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)renderable;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        super.handleImageButtons((TitleScreen)this, xOffset);
    }

    private void setupLogo(PoseStack poseStack, float transparency, float scale) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)AETHER_LOGO);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
        int width = (int)(288.0f / scale);
        int height = (int)(144.0f / scale);
        int logoX = (int)((float)(this.f_96543_ / 2) - 144.0f / scale);
        int logoY = (int)(0.0f + 10.0f / scale);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)logoX, (int)logoY, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static float getScale(ReduxTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.m_91268_().m_85385_(((Integer)minecraft.f_91066_.m_231928_().m_231551_()).intValue(), minecraft.m_91390_());
        return ReduxTitleScreen.calculateScale(screen, guiScale, guiScale - 1);
    }

    public static float calculateScale(ReduxTitleScreen screen, float guiScale, float lowerScale) {
        int range;
        float scale = 1.0f;
        if (guiScale > 1.0f) {
            scale = guiScale / lowerScale;
        }
        if ((range = ReduxMenuButton.totalHeightRange(screen.rows, scale)) > screen.f_96544_ && scale != 1.0f) {
            return ReduxTitleScreen.calculateScale(screen, guiScale, lowerScale - 1.0f);
        }
        return scale;
    }

    protected <T extends GuiEventListener & Widget> T m_142416_(T renderable) {
        Button button;
        if (renderable instanceof Button && TitleScreenBehavior.isMainButton((Component)(button = (Button)renderable).m_6035_())) {
            ReduxMenuButton aetherButton = new ReduxMenuButton(this, button);
            return (T)super.m_142416_((GuiEventListener)aetherButton);
        }
        return (T)super.m_142416_(renderable);
    }

    public void m_7379_() {
        super.m_7379_();
    }
}

