/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.backported;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntIterator;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.zepalesque.redux.client.gui.backported.Divisor;

public class GuiGraphicsHelper {
    public static void enableScissor(int minX, int minY, int maxX, int maxY) {
        GuiGraphicsHelper.applyScissor(minX, minY, maxX - minX, maxY - minY);
    }

    private static void applyScissor(int x, int y, int width, int height) {
        Window window = Minecraft.m_91087_().m_91268_();
        int i = window.m_85442_();
        double scale = window.m_85449_();
        double calcX = (double)x * scale;
        double calcY = (double)i - (double)(y + height) * scale;
        double calcWidth = (double)width * scale;
        double calcHeight = (double)height * scale;
        RenderSystem.m_69488_((int)((int)calcX), (int)((int)calcY), (int)Math.max(0, (int)calcWidth), (int)Math.max(0, (int)calcHeight));
    }

    public static void blitNineSliced(ResourceLocation atlasLocation, PoseStack poseStack, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int uWidth, int vHeight, int textureX, int textureY) {
        leftSliceWidth = Math.min(leftSliceWidth, width / 2);
        rightSliceWidth = Math.min(rightSliceWidth, width / 2);
        topSliceHeight = Math.min(topSliceHeight, height / 2);
        bottomSliceHeight = Math.min(bottomSliceHeight, height / 2);
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlasLocation);
        poseStack.m_85836_();
        if (width == uWidth && height == vHeight) {
            GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)textureX, (float)textureY, (int)width, (int)height, (int)256, (int)256);
        } else if (height == vHeight) {
            GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)textureX, (float)textureY, (int)leftSliceWidth, (int)height, (int)256, (int)256);
            GuiGraphicsHelper.blitRepeating(poseStack, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, vHeight);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)(x + width - rightSliceWidth), (int)y, (int)0, (float)(textureX + uWidth - rightSliceWidth), (float)textureY, (int)rightSliceWidth, (int)height, (int)256, (int)256);
        } else if (width == uWidth) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)textureX, (float)textureY, (int)width, (int)topSliceHeight, (int)256, (int)256);
            GuiGraphicsHelper.blitRepeating(poseStack, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, uWidth, vHeight - bottomSliceHeight - topSliceHeight);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)(y + height - bottomSliceHeight), (float)textureX, (float)(textureY + vHeight - bottomSliceHeight), (int)width, (int)bottomSliceHeight, (int)256, (int)256);
        } else {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)textureX, (float)textureY, (int)leftSliceWidth, (int)topSliceHeight, (int)256, (int)256);
            GuiGraphicsHelper.blitRepeating(poseStack, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, topSliceHeight);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width - rightSliceWidth), (int)y, (float)(textureX + uWidth - rightSliceWidth), (float)textureY, (int)rightSliceWidth, (int)topSliceHeight, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)(y + height - bottomSliceHeight), (float)textureX, (float)(textureY + vHeight - bottomSliceHeight), (int)leftSliceWidth, (int)bottomSliceHeight, (int)256, (int)256);
            GuiGraphicsHelper.blitRepeating(poseStack, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, textureX + leftSliceWidth, textureY + vHeight - bottomSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width - rightSliceWidth), (int)(y + height - bottomSliceHeight), (float)(textureX + uWidth - rightSliceWidth), (float)(textureY + vHeight - bottomSliceHeight), (int)rightSliceWidth, (int)bottomSliceHeight, (int)256, (int)256);
            GuiGraphicsHelper.blitRepeating(poseStack, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
            GuiGraphicsHelper.blitRepeating(poseStack, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + leftSliceWidth, textureY + topSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
            GuiGraphicsHelper.blitRepeating(poseStack, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + uWidth - rightSliceWidth, textureY + topSliceHeight, rightSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
        }
        poseStack.m_85849_();
    }

    public static void blitNineSliced(ResourceLocation atlasLocation, PoseStack poseStack, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int textureX, int textureY) {
        GuiGraphicsHelper.blitNineSliced(atlasLocation, poseStack, x, y, width, height, sliceWidth, sliceHeight, sliceWidth, sliceHeight, uWidth, vHeight, textureX, textureY);
    }

    public static void blitRepeating(PoseStack poseStack, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight) {
        GuiGraphicsHelper.blitRepeating(poseStack, x, y, width, height, uOffset, vOffset, sourceWidth, sourceHeight, 256, 256);
    }

    public static void blitRepeating(PoseStack poseStack, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight, int textureWidth, int textureHeight) {
        int i = x;
        IntIterator intiterator = GuiGraphicsHelper.slices(width, sourceWidth);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (sourceWidth - j) / 2;
            int l = y;
            IntIterator intiterator1 = GuiGraphicsHelper.slices(height, sourceHeight);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (sourceHeight - i1) / 2;
                GuiComponent.m_93133_((PoseStack)poseStack, (int)i, (int)l, (float)(uOffset + k), (float)(vOffset + j1), (int)j, (int)i1, (int)textureWidth, (int)textureHeight);
                l += i1;
            }
            i += j;
        }
    }

    private static IntIterator slices(int target, int total) {
        int i = Mth.m_184652_((int)target, (int)total);
        return new Divisor(target, i);
    }

    public static void renderScrollingString(PoseStack guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        int textWidth = font.m_92852_((FormattedText)text);
        int textY = (minY + maxY - 9) / 2 + 1;
        int width = maxX - minX;
        int height = maxY - minY;
        if (textWidth > width) {
            int diff = textWidth - width;
            double time = (double)Util.m_137550_() / 1000.0;
            double duration = Math.max((double)diff * 0.5, 3.0);
            double percent = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * time / duration)) / 2.0 + 0.5;
            double offset = Mth.m_14139_((double)percent, (double)0.0, (double)diff);
            GuiGraphicsHelper.enableScissor(minX, minY, maxX, maxY);
            GuiGraphicsHelper.drawString(guiGraphics, font, text, minX - (int)offset, textY, color);
            RenderSystem.m_69471_();
        } else {
            GuiGraphicsHelper.drawCenteredString(guiGraphics, font, text, (minX + maxX) / 2, textY, color);
        }
    }

    public static void drawCenteredString(PoseStack pPoseStack, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        pFont.m_92744_(pPoseStack, formattedcharsequence, (float)(pX - pFont.m_92724_(formattedcharsequence) / 2), (float)pY, pColor);
    }

    public static void drawString(PoseStack pPoseStack, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        pFont.m_92744_(pPoseStack, formattedcharsequence, (float)pX, (float)pY, pColor);
    }
}

