/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client;

import java.util.Optional;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.orcinus.galosphere.init.GItems;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.blockentity.ReduxMenuTypes;
import net.zepalesque.redux.capability.living.VampireAmulet;
import net.zepalesque.redux.client.gui.screen.HolystoneFurnaceScreen;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.item.accessory.VampireAmuletItem;
import net.zepalesque.redux.item.weapons.SubzeroCrossbowItem;
import org.apache.commons.lang3.function.TriFunction;

@Mod.EventBusSubscriber(modid="aether_redux", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ReduxClient {
    public static void fixSignTextures(WoodHandler handler) {
        ResourceLocation texture = Redux.locate("entity/signs/" + handler.woodName);
        Material material = new Material(Sheets.f_110739_, texture);
        Sheets.f_110743_.put(handler.woodType, material);
    }

    public static void registerItemModelProperties() {
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("pull"), (stack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return SubzeroCrossbowItem.m_40932_(stack) ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / (float)SubzeroCrossbowItem.m_40939_(stack);
        });
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("pulling"), (stack, level, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack && !SubzeroCrossbowItem.m_40932_(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("charged"), (stack, level, entity, seed) -> SubzeroCrossbowItem.m_40932_(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("firework"), (stack, level, entity, seed) -> SubzeroCrossbowItem.m_40932_(stack) && SubzeroCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
        if (Redux.galosphereCompat()) {
            ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("galosphere", "glow_flare"), (stack, world, entity, i) -> entity != null && SubzeroCrossbowItem.m_40932_(stack) && SubzeroCrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)GItems.GLOW_FLARE.get())) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("galosphere", "spectre_flare"), (stack, world, entity, i) -> entity != null && SubzeroCrossbowItem.m_40932_(stack) && SubzeroCrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)GItems.SPECTRE_FLARE.get())) ? 1.0f : 0.0f);
        }
        ItemProperties.register((Item)((Item)ReduxItems.VAMPIRE_AMULET.get()), (ResourceLocation)Redux.locate("active"), (stack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            Optional isActive = VampireAmulet.get(entity).map(VampireAmulet::canUseAbility);
            return VampireAmuletItem.validForActivation(stack) && isActive.isPresent() && (Boolean)isActive.get() != false ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)((Item)ReduxItems.SPEAR_OF_THE_BLIGHT.get()), (ResourceLocation)Redux.locate("throwing"), (stack, level, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Block)ReduxBlocks.AURUM.get()).m_5456_(), (ResourceLocation)Redux.locate("enchanted"), (stack, world, living, seed) -> (Boolean)ReduxConfig.COMMON.enchanted_gilded_grass.get() != false ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Block)ReduxBlocks.GOLDEN_CLOVER.get()).m_5456_(), (ResourceLocation)Redux.locate("enchanted"), (stack, world, living, seed) -> (Boolean)ReduxConfig.COMMON.enchanted_gilded_grass.get() != false ? 1.0f : 0.0f);
    }

    public static void registerGuiFactories() {
        ReduxClient.registerMenu((MenuType)ReduxMenuTypes.HOLYSTONE_FURNACE.get(), HolystoneFurnaceScreen::new);
    }

    private static <M extends AbstractContainerMenu, S extends Screen> void registerMenu(MenuType<M> type, TriFunction<M, Inventory, Component, S> constructor) {
        MenuScreens.m_96206_(type, (menu, inventory, component) -> (Screen)constructor.apply((Object)menu, (Object)inventory, (Object)component));
    }
}

