/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability.swet;

import com.aetherteam.aether.entity.block.FloatingBlockEntity;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.item.EquipmentUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.zepalesque.redux.capability.swet.SwetMass;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.data.resource.ReduxDamageTypes;
import net.zepalesque.redux.event.hook.SwetHooks;
import net.zepalesque.redux.misc.ReduxTags;

public class SwetMassCapability
implements SwetMass {
    protected static final AttributeModifier knockbackResistanceModifier = new AttributeModifier("Temporary swet knockback resistance", 1.0, AttributeModifier.Operation.ADDITION);
    private final Swet swet;
    protected float massStuck = 0.0f;

    public SwetMassCapability(Swet swet) {
        this.swet = swet;
    }

    @Override
    public Swet getSwet() {
        return this.swet;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
    }

    @Override
    public void tick() {
        if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue() && !this.getSwet().m_21224_()) {
            this.massStuck = 0.0f;
            this.getSwet().f_19853_.m_45933_((Entity)this.getSwet(), this.getSwet().m_20191_().m_82377_(0.9, 0.9, 0.9)).forEach(entity -> {
                AABB box = entity.m_20191_();
                this.massStuck = (float)((double)this.massStuck + box.m_82362_() * box.m_82376_() * box.m_82385_());
            });
            this.getSwet().f_19853_.m_45933_((Entity)this.getSwet(), this.getSwet().m_20191_()).forEach(this::onEntityCollision);
        }
    }

    protected void onEntityCollision(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof Swet || entity.m_6095_().m_204039_(ReduxTags.EntityTypes.SWET_PASSTHROUGH)) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (SwetHooks.canGrow(this.getSwet(), item.m_32055_())) {
                this.getSwet().m_7839_(this.getSwet().m_33632_() + 1, false);
                item.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            item.m_7998_((Entity)this.getSwet(), true);
            return;
        }
        if (entity instanceof LivingEntity && EquipmentUtil.hasSwetCape((LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return;
        }
        boolean absorbable = SwetMassCapability.isAbsorbable(entity, this.getSwet().f_19853_);
        if (SwetHooks.canAbsorbEntities(this.getSwet()) && absorbable) {
            if (this.massStuck < 1.0f) {
                this.massStuck = 1.0f;
            }
            Vec3 center = this.getSwet().m_20191_().m_82399_().m_82520_(0.0, (double)0.45f * this.getSwet().m_20191_().m_82376_() - (double)(this.getSwet().m_33632_() == 0 ? -0.25f : 1.0f), 0.0);
            Vec3 suckVelocity = center.m_82546_(entity.m_20182_()).m_82490_(Mth.m_14008_((double)(0.25 + (double)(this.massStuck / 100.0f)), (double)0.0, (double)1.0)).m_82549_(this.getSwet().m_20184_().m_82546_(entity.m_20184_()).m_82490_(0.45 / (double)this.massStuck / SwetHooks.getAbsorbVectorScale(this.getSwet())));
            double maxSpeed = SwetHooks.getAbsorbVectorScale(this.getSwet()) * 0.1 + 0.25;
            if (suckVelocity.m_82553_() != 0.0) {
                suckVelocity = suckVelocity.m_82490_(Math.min(1.0, maxSpeed / suckVelocity.m_82553_()));
            }
            entity.m_20256_(entity.m_20184_().m_82549_(suckVelocity));
            entity.f_19812_ = true;
            entity.f_19789_ = 0.0f;
        }
        if (entity instanceof Player) {
            Player livingEntity2 = (Player)entity;
            if (SwetHooks.canAbsorbEntities(this.getSwet()) && SwetHooks.canDamageEntities(this.getSwet())) {
                AttributeInstance knockbackResistance = livingEntity2.m_21051_(Attributes.f_22278_);
                if (absorbable && knockbackResistance != null) {
                    knockbackResistance.m_22118_(knockbackResistanceModifier);
                    this.damage((LivingEntity)livingEntity2);
                    knockbackResistance.m_22130_(knockbackResistanceModifier);
                } else {
                    this.damage((LivingEntity)livingEntity2);
                }
            }
        }
    }

    protected void damage(LivingEntity livingEntity) {
        if (livingEntity.m_6469_(ReduxDamageTypes.swetAbsorption((Entity)this.getSwet()), SwetHooks.getDamage(this.getSwet()))) {
            this.getSwet().m_5496_((SoundEvent)ReduxSoundEvents.SWET_ATTACK.get(), 1.0f, (this.getSwet().m_217043_().m_188501_() - this.getSwet().m_217043_().m_188501_()) * 0.2f + 1.0f);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean isAbsorbable(Entity entity, Level world) {
        if (entity.m_5829_()) {
            return false;
        }
        if (!(entity instanceof LivingEntity || entity instanceof PrimedTnt || entity instanceof MinecartTNT || entity instanceof FloatingBlockEntity)) {
            return false;
        }
        canPickupNonPlayers = world.m_46469_().m_46207_(GameRules.f_46132_);
        v0 = isPet = entity instanceof TamableAnimal != false && (pet = (TamableAnimal)entity).m_21824_() != false;
        if (!(entity instanceof Player)) ** GOTO lbl-1000
        player = (Player)entity;
        if (!player.m_150110_().f_35935_) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isEligiblePlayer = v1;
        isEligiblePet = isPet != false && world.m_46791_() != Difficulty.EASY;
        isEligibleNonPlayer = entity instanceof Player == false && isPet == false && canPickupNonPlayers != false;
        return entity.m_6144_() == false && (isEligiblePlayer != false || isEligiblePet != false || isEligibleNonPlayer != false);
    }
}

