/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability.player;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.zepalesque.redux.capability.player.PlayerTickModule;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.effect.ReduxEffects;
import net.zepalesque.redux.util.math.MathUtil;

public class AdrenalineModule
implements PlayerTickModule {
    private final Player player;
    private int maxPulseTicks = 0;
    private int currPulseTicks = 0;
    private double adrenalineStrength = 0.0;
    private int cooldown = 0;

    public AdrenalineModule(Player plr) {
        this.player = plr;
    }

    @Override
    public void tick() {
        if (this.player.f_19853_.m_5776_()) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.player.m_21023_((MobEffect)ReduxEffects.ADRENALINE_RUSH.get())) {
                MobEffectInstance i = this.player.m_21124_((MobEffect)ReduxEffects.ADRENALINE_RUSH.get());
                double amount = Math.min((double)i.m_19557_() / 600.0, 1.0);
                this.adrenalineStrength = amount / 3.0 * (double)Math.min(3, i.m_19564_() + 1);
            } else {
                this.adrenalineStrength = 0.0;
            }
            if (this.adrenalineStrength > 0.0) {
                this.maxPulseTicks = MathUtil.lerpInt((float)this.adrenalineStrength, 20, 10);
            } else {
                this.setMaxPulseTicks(0);
            }
            if (this.maxPulseTicks > 0) {
                if (this.currPulseTicks < this.maxPulseTicks) {
                    ++this.currPulseTicks;
                } else {
                    this.currPulseTicks = 0;
                    this.doPulse(this.adrenalineStrength);
                }
            }
        }
    }

    public float getTransparency(float partial) {
        float delta = ((float)this.currPulseTicks + partial) / (float)this.maxPulseTicks + 1.0f;
        return this.adrenalineStrength <= 0.0 ? 0.0f : AdrenalineModule.sinWaveInterp(delta) * 0.5f * ((float)this.adrenalineStrength / 2.0f + 0.5f);
    }

    public float getShaderStrength() {
        return this.adrenalineStrength > 0.0 ? (float)this.adrenalineStrength * 0.67f + 0.33f : 0.0f;
    }

    private static float sinWaveInterp(float delta) {
        return Mth.m_14031_((float)((float)Math.PI * 2 * delta)) / 2.0f + 0.5f;
    }

    private static SoundEvent getHeartbeat(double strength) {
        return strength >= 0.67 ? (SoundEvent)ReduxSoundEvents.HEARTBEAT_FAST.get() : (strength >= 0.33 ? (SoundEvent)ReduxSoundEvents.HEARTBEAT_MED.get() : (SoundEvent)ReduxSoundEvents.HEARTBEAT_SLOW.get());
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    protected void doPulse(double strength) {
        this.player.f_19853_.m_6263_(this.player, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), AdrenalineModule.getHeartbeat(strength), SoundSource.PLAYERS, 0.8f, 1.0f);
    }

    public boolean cooledDown() {
        return this.cooldown <= 0;
    }

    public void beginCooldown() {
        this.cooldown = 1200;
    }

    public void setMaxPulseTicks(int ticks) {
        this.maxPulseTicks = ticks;
    }
}

