/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability.living;

import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.simple.SimpleChannel;
import net.zepalesque.redux.capability.living.VampireAmulet;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.VampireAmuletSyncPacket;
import org.apache.commons.lang3.tuple.Triple;

public class VampireAmuletCapability
implements VampireAmulet {
    private final LivingEntity mob;
    private boolean hasCurio = false;
    private boolean active = false;
    private int timer = 24000;
    private int timeWithout = 0;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("ability_enabled", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setAbilityUse((Boolean)object), this::canUseAbility)));

    public VampireAmuletCapability(LivingEntity mob) {
        this.mob = mob;
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    @Override
    public LivingEntity getMob() {
        return this.mob;
    }

    @Override
    public boolean canUseAbility() {
        return this.active;
    }

    @Override
    public void setAbilityUse(boolean b) {
        this.active = b;
    }

    @Override
    public int countdown() {
        return this.timer;
    }

    @Override
    public boolean hasCurio() {
        return this.hasCurio;
    }

    @Override
    public void resetTimer() {
        this.timer = 24000;
    }

    @Override
    public void tick() {
        if (!this.mob.f_19853_.m_5776_()) {
            this.hasCurio = EquipmentUtil.hasCurio((LivingEntity)this.getMob(), (Item)((Item)ReduxItems.VAMPIRE_AMULET.get()));
            this.timeWithout = !this.hasCurio && this.timeWithout < 20 ? ++this.timeWithout : 0;
            if (this.timeWithout >= 20) {
                this.resetTimer();
            }
            if (this.hasCurio && this.timer > 0) {
                --this.timer;
            }
            if (this.hasCurio && this.timer <= 0 && !this.canUseAbility()) {
                this.setSynched(INBTSynchable.Direction.CLIENT, "ability_enabled", true);
            }
            if ((!this.hasCurio || this.timer > 0) && this.canUseAbility()) {
                this.setSynched(INBTSynchable.Direction.CLIENT, "ability_enabled", false);
            }
        }
    }

    public BasePacket getSyncPacket(String s, INBTSynchable.Type type, Object o) {
        return new VampireAmuletSyncPacket(this.getMob().m_19879_(), s, type, o);
    }

    public SimpleChannel getPacketChannel() {
        return ReduxPacketHandler.INSTANCE;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("active", this.active);
        nbt.m_128405_("timer", this.timer);
        nbt.m_128379_("has_curio", this.hasCurio);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.active = nbt.m_128471_("active");
        this.timer = nbt.m_128451_("timer");
        this.hasCurio = nbt.m_128471_("has_curio");
    }
}

