/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.block.natural;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zepalesque.redux.block.natural.ReduxDoubleDropsWall;
import net.zepalesque.redux.block.util.state.ReduxStates;
import net.zepalesque.redux.mixin.common.block.ReduxWallBlockAccessor;

public class ReduxNaturalWall
extends ReduxDoubleDropsWall {
    public ReduxNaturalWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ReduxStates.NATURAL_GEN, (Comparable)Boolean.valueOf(false)));
        this.fixShapeMaps2();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ReduxStates.NATURAL_GEN});
    }

    private void fixShapeMaps2() {
        ReduxWallBlockAccessor reduxWallBlockAccessor = (ReduxWallBlockAccessor)((Object)this);
        Map<BlockState, VoxelShape> shapeByIndex = reduxWallBlockAccessor.getShapeByIndex();
        shapeByIndex = ReduxNaturalWall.fixShapeMap2(shapeByIndex);
        reduxWallBlockAccessor.setShapeByIndex(shapeByIndex);
        Map<BlockState, VoxelShape> collisionShapeByIndex = reduxWallBlockAccessor.getCollisionShapeByIndex();
        collisionShapeByIndex = ReduxNaturalWall.fixShapeMap2(collisionShapeByIndex);
        reduxWallBlockAccessor.setCollisionShapeByIndex(collisionShapeByIndex);
    }

    private static Map<BlockState, VoxelShape> fixShapeMap2(Map<BlockState, VoxelShape> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(map);
        for (BlockState state : map.keySet()) {
            builder.put((Object)((BlockState)state.m_61122_((Property)ReduxStates.NATURAL_GEN)), (Object)map.get(state));
        }
        return builder.build();
    }
}

