/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;

public final class MusicPredicate
implements Predicate<Music> {
    public static final Codec<HolderSet<SoundEvent>> SOUND_EVENT_SET = RegistryCodecs.m_206279_((ResourceKey)Registry.f_122821_.m_123023_(), (Codec)SoundEvent.f_11655_);
    public static final Codec<MusicPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SOUND_EVENT_SET.optionalFieldOf("sounds").forGetter(MusicPredicate::sounds), (App)Codec.INT.listOf().optionalFieldOf("valid_min_delays").forGetter(MusicPredicate::minDelays), (App)Codec.INT.listOf().optionalFieldOf("valid_max_delays").forGetter(MusicPredicate::maxDelays), (App)Codec.BOOL.optionalFieldOf("replaces_current").forGetter(MusicPredicate::replaceCurrent)).apply((Applicative)builder, MusicPredicate::new));
    private final Optional<HolderSet<SoundEvent>> sounds;
    private final Optional<List<SoundEvent>> soundList;
    private final Optional<List<Integer>> minDelays;
    private final Optional<List<Integer>> maxDelays;
    private final Optional<Boolean> replaceCurrent;

    public MusicPredicate(Optional<HolderSet<SoundEvent>> sounds, Optional<List<Integer>> minDelays, Optional<List<Integer>> maxDelays, Optional<Boolean> replaceCurrent) {
        this.sounds = sounds;
        this.minDelays = minDelays;
        this.maxDelays = maxDelays;
        this.replaceCurrent = replaceCurrent;
        this.soundList = sounds.map(set -> set.m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).toList());
    }

    @Override
    public boolean test(Music music) {
        if (this.soundList.isPresent() && !this.soundList.get().contains(music.m_11631_())) {
            return false;
        }
        if (this.minDelays.isPresent() && !this.minDelays.get().isEmpty() && !this.minDelays.get().contains(music.m_11636_())) {
            return false;
        }
        if (this.maxDelays.isPresent() && !this.maxDelays.get().isEmpty() && !this.maxDelays.get().contains(music.m_11639_())) {
            return false;
        }
        return this.replaceCurrent.isEmpty() || music.m_11642_() == this.replaceCurrent.get().booleanValue();
    }

    public Optional<HolderSet<SoundEvent>> sounds() {
        return this.sounds;
    }

    public Optional<List<Integer>> minDelays() {
        return this.minDelays;
    }

    public Optional<List<Integer>> maxDelays() {
        return this.maxDelays;
    }

    public Optional<Boolean> replaceCurrent() {
        return this.replaceCurrent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MusicPredicate that = (MusicPredicate)obj;
        return Objects.equals(this.sounds, that.sounds) && Objects.equals(this.minDelays, that.minDelays) && Objects.equals(this.maxDelays, that.maxDelays) && Objects.equals(this.replaceCurrent, that.replaceCurrent);
    }

    public int hashCode() {
        return Objects.hash(this.sounds, this.minDelays, this.maxDelays, this.replaceCurrent);
    }

    public String toString() {
        return "MusicPredicate[sounds=" + this.sounds + ", minDelays=" + this.minDelays + ", maxDelays=" + this.maxDelays + ", replaceCurrent=" + this.replaceCurrent + "]";
    }
}

