/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.blockhandler;

import com.aetherteam.aether.block.construction.BookshelfBlock;
import com.aetherteam.aether.block.natural.AetherLogBlock;
import com.aetherteam.aether.item.AetherCreativeTabs;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;
import net.zepalesque.redux.api.blockhandler.BlockHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.construction.LayeredBookshelfBlock;
import net.zepalesque.redux.block.natural.ReduxNaturalLog;
import net.zepalesque.redux.block.natural.ReduxNaturalWall;
import net.zepalesque.redux.block.sign.ReduxSignBlock;
import net.zepalesque.redux.block.sign.ReduxWallSignBlock;
import net.zepalesque.redux.blockentity.ReduxBlockEntityTypes;
import net.zepalesque.redux.blockentity.ReduxSignBlockEntity;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.entity.misc.ReduxBoat;
import net.zepalesque.redux.entity.misc.ReduxChestBoat;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.item.misc.ReduxBoatItem;
import net.zepalesque.redux.misc.ReduxTags;
import org.jetbrains.annotations.Nullable;

public class WoodHandler
implements BlockHandler {
    public final TagKey<Item> logsTag;
    public final TagKey<Block> logsBlockTag;
    public final Optional<TagKey<Block>> sporingBlocksBlockTag;
    public final RegistryObject<Block> planks;
    public final RegistryObject<RotatedPillarBlock> log;
    public final RegistryObject<RotatedPillarBlock> wood;
    public final Optional<RegistryObject<RotatedPillarBlock>> strippedLog;
    public final Optional<RegistryObject<RotatedPillarBlock>> strippedWood;
    public final RegistryObject<StairBlock> stairs;
    public final RegistryObject<SlabBlock> slab;
    public final RegistryObject<FenceBlock> fence;
    public final RegistryObject<FenceGateBlock> fenceGate;
    public final RegistryObject<DoorBlock> door;
    public final RegistryObject<TrapDoorBlock> trapdoor;
    public final RegistryObject<PressurePlateBlock> pressurePlate;
    public final RegistryObject<ButtonBlock> button;
    public final RegistryObject<BookshelfBlock> bookshelf;
    public final RegistryObject<StandingSignBlock> sign;
    public final RegistryObject<WallSignBlock> wallSign;
    public final RegistryObject<SignItem> signItem;
    public final RegistryObject<ReduxBoatItem> boatItem;
    public final RegistryObject<ReduxBoatItem> chestBoatItem;
    public final RegistryObject<WallBlock> logWall;
    public final RegistryObject<WallBlock> woodWall;
    public final Optional<RegistryObject<WallBlock>> strippedLogWall;
    public final Optional<RegistryObject<WallBlock>> strippedWoodWall;
    public final RegistryObject<EntityType<ReduxBoat>> boatEntity;
    public final RegistryObject<EntityType<ReduxChestBoat>> chestBoatEntity;
    public final RegistryObject<BlockEntityType<ReduxSignBlockEntity>> signEntity;
    public final WoodType woodType;
    public final String woodName;
    @Nullable
    public final String langName;
    public final boolean alwaysLogWalls;
    public final SoundType plankSoundType;
    public final SoundType logSoundType;
    public final String logSuffix;
    public final String woodSuffix;
    public final boolean hasSporingLogs;
    public final boolean hasStrippedLogs;
    public final boolean layeredBookshelf;
    public final Optional<RegistryObject<RotatedPillarBlock>> sporingLog;
    public final Optional<RegistryObject<RotatedPillarBlock>> sporingWood;
    public final String treeName;

    public static WoodHandler tree(String pWoodname, boolean pLogWalls, MaterialColor pBarkColor, MaterialColor pWoodColor, boolean layeredBookshelf) {
        return WoodHandler.handler(pWoodname, null, true, "trees", "log", "wood", SoundType.f_56736_, SoundType.f_56736_, pLogWalls, pBarkColor, pWoodColor, false, layeredBookshelf);
    }

    public static WoodHandler fungus(String pWoodname, boolean pLogWalls, MaterialColor pBarkColor, MaterialColor pWoodColor, boolean layeredBookshelf) {
        return WoodHandler.handler(pWoodname, null, true, "mushrooms", "stem", "hyphae", SoundType.f_56736_, SoundType.f_56763_, pLogWalls, pBarkColor, pWoodColor, false, layeredBookshelf);
    }

    public static WoodHandler noStrippingFungus(String pWoodname, boolean pLogWalls, MaterialColor pBarkColor, MaterialColor pWoodColor, boolean layeredBookshelf) {
        return WoodHandler.handler(pWoodname, null, false, "mushrooms", "stem", "hyphae", SoundType.f_56736_, SoundType.f_56763_, pLogWalls, pBarkColor, pWoodColor, false, layeredBookshelf);
    }

    public static WoodHandler handler(String pWoodName, @Nullable String pLangName, boolean pStrippedLog, String pTreeName, String pLogSuffix, String pWoodSuffix, SoundType pPlankSoundType, SoundType pLogSoundType, boolean pLogWalls, MaterialColor barkColor, MaterialColor woodColor, boolean hasSporingLogs, boolean layeredBookshelf) {
        WoodHandler instance = new WoodHandler(pWoodName, pLangName, pStrippedLog, pTreeName, pLogSuffix, pWoodSuffix, pPlankSoundType, pLogSoundType, pLogWalls, barkColor, woodColor, hasSporingLogs, layeredBookshelf);
        return instance;
    }

    protected WoodHandler(String pWoodName, @Nullable String pLangName, boolean pStrippedLogs, String pTreeName, String pLogSuffix, String pWoodSuffix, SoundType pPlankSoundType, SoundType pLogSoundType, boolean pLogWalls, MaterialColor barkColor, MaterialColor woodColor, boolean pSporingLogs, boolean layeredBookshelf) {
        this.hasSporingLogs = pSporingLogs;
        this.hasStrippedLogs = pStrippedLogs;
        this.treeName = pTreeName;
        if (pSporingLogs) {
            RegistryObject sporingLogRegistry = ReduxBlocks.register("sporing_" + pWoodName + "_" + pLogSuffix, () -> new AetherLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(pLogSoundType).m_155949_(barkColor)));
            this.sporingLog = Optional.of(sporingLogRegistry);
            RegistryObject sporingWoodRegistry = ReduxBlocks.register("sporing_" + pWoodName + "_" + pWoodSuffix, () -> new AetherLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(pLogSoundType).m_155949_(barkColor)));
            this.sporingWood = Optional.of(sporingWoodRegistry);
            this.sporingBlocksBlockTag = Optional.of(ReduxTags.Blocks.tag("sporing_" + pWoodName + "_" + pLogSuffix + "s"));
        } else {
            this.sporingLog = Optional.empty();
            this.sporingWood = Optional.empty();
            this.sporingBlocksBlockTag = Optional.empty();
        }
        this.logSuffix = pLogSuffix;
        this.woodSuffix = pWoodSuffix;
        this.alwaysLogWalls = pLogWalls;
        this.plankSoundType = pPlankSoundType;
        this.logSoundType = pLogSoundType;
        this.logsTag = ReduxTags.Items.tag(pWoodName + "_" + pLogSuffix + "s");
        this.logsBlockTag = ReduxTags.Blocks.tag(pWoodName + "_" + pLogSuffix + "s");
        this.woodName = pWoodName;
        this.langName = pLangName;
        this.bookshelf = ReduxBlocks.register(pWoodName + "_bookshelf", layeredBookshelf ? () -> new LayeredBookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_).m_155949_(woodColor).m_60918_(pPlankSoundType)) : () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_).m_155949_(woodColor).m_60918_(pPlankSoundType)));
        this.layeredBookshelf = layeredBookshelf;
        this.woodType = WoodType.create((String)("aether_redux:" + pWoodName));
        this.signEntity = ReduxBlockEntityTypes.BLOCK_ENTITY_TYPES.register(pWoodName + "_sign", () -> BlockEntityType.Builder.m_155273_((pPos, pState) -> new ReduxSignBlockEntity(pPos, pState, (BlockEntityType<ReduxSignBlockEntity>)((BlockEntityType)this.getSign().get())), (Block[])new Block[]{(Block)this.getSignBlock().get(), (Block)this.getWallSignBlock().get()}).m_58966_(null));
        this.boatEntity = ReduxEntityTypes.ENTITY_TYPES.register(pWoodName + "_boat", () -> EntityType.Builder.m_20704_(ReduxBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(pWoodName + "_boat"));
        this.chestBoatEntity = ReduxEntityTypes.ENTITY_TYPES.register(pWoodName + "_chest_boat", () -> EntityType.Builder.m_20704_(ReduxChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(pWoodName + "_chest_boat"));
        this.log = ReduxBlocks.register(pWoodName + "_" + pLogSuffix, () -> new AetherLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(pLogSoundType).m_155949_(barkColor)));
        this.wood = ReduxBlocks.register(pWoodName + "_" + pWoodSuffix, () -> new ReduxNaturalLog(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60918_(pLogSoundType).m_155949_(barkColor)));
        if (this.hasStrippedLogs) {
            RegistryObject strippedLog = ReduxBlocks.register("stripped_" + pWoodName + "_" + pLogSuffix, () -> new ReduxNaturalLog(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_).m_60918_(pLogSoundType).m_155949_(woodColor)));
            this.strippedLog = Optional.of(strippedLog);
            RegistryObject strippedWood = ReduxBlocks.register("stripped_" + pWoodName + "_" + pWoodSuffix, () -> new ReduxNaturalLog(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_).m_60918_(pLogSoundType).m_155949_(woodColor)));
            this.strippedWood = Optional.of(strippedWood);
            RegistryObject strippedLogWall = ReduxBlocks.register("stripped_" + this.woodName + "_" + pLogSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(woodColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
            RegistryObject strippedWoodWall = ReduxBlocks.register("stripped_" + this.woodName + "_" + pWoodSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(woodColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
            this.strippedLogWall = Optional.of(strippedLogWall);
            this.strippedWoodWall = Optional.of(strippedWoodWall);
        } else {
            this.strippedLog = Optional.empty();
            this.strippedWood = Optional.empty();
            this.strippedLogWall = Optional.empty();
            this.strippedWoodWall = Optional.empty();
        }
        this.planks = ReduxBlocks.register(pWoodName + "_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60918_(pPlankSoundType).m_155949_(woodColor)));
        this.stairs = ReduxBlocks.register(pWoodName + "_stairs", () -> new StairBlock(() -> ((Block)this.planks.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.planks.get()))));
        this.slab = ReduxBlocks.register(pWoodName + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.planks.get())).m_60913_(2.0f, 3.0f)));
        this.fence = ReduxBlocks.register(pWoodName + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_).m_60918_(pPlankSoundType).m_155949_(woodColor)));
        this.fenceGate = ReduxBlocks.register(pWoodName + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_).m_60918_(pPlankSoundType).m_155949_(woodColor)));
        this.door = ReduxBlocks.register(pWoodName + "_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_).m_60918_(pPlankSoundType).m_155949_(woodColor)));
        this.trapdoor = ReduxBlocks.register(pWoodName + "_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_).m_60918_(pPlankSoundType).m_155949_(woodColor)));
        this.pressurePlate = ReduxBlocks.register(pWoodName + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_60918_(pPlankSoundType).m_155949_(woodColor)));
        this.button = ReduxBlocks.register(pWoodName + "_button", () -> new WoodButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_).m_60918_(pPlankSoundType).m_155949_(woodColor)));
        this.sign = ReduxBlocks.BLOCKS.register(pWoodName + "_sign", () -> new ReduxSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(woodColor).m_60910_().m_60978_(1.0f).m_60918_(pPlankSoundType), this.woodType){

            @Override
            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return new ReduxSignBlockEntity(pos, state, (BlockEntityType<ReduxSignBlockEntity>)((BlockEntityType)WoodHandler.this.getSign().get()));
            }
        });
        this.wallSign = ReduxBlocks.BLOCKS.register(pWoodName + "_wall_sign", () -> new ReduxWallSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(woodColor).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), this.woodType){

            @Override
            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return new ReduxSignBlockEntity(pos, state, (BlockEntityType<ReduxSignBlockEntity>)((BlockEntityType)WoodHandler.this.getSign().get()));
            }
        });
        this.boatItem = ReduxItems.ITEMS.register(pWoodName + "_boat", () -> new ReduxBoatItem(false, new Item.Properties().m_41487_(1).m_41491_(AetherCreativeTabs.AETHER_EQUIPMENT_AND_UTILITIES), (level, hitresult) -> new ReduxBoat(this, (Level)level, hitresult.m_82450_().f_82479_, hitresult.m_82450_().f_82480_, hitresult.m_82450_().f_82481_){}));
        this.chestBoatItem = ReduxItems.ITEMS.register(pWoodName + "_chest_boat", () -> new ReduxBoatItem(false, new Item.Properties().m_41487_(1).m_41491_(AetherCreativeTabs.AETHER_EQUIPMENT_AND_UTILITIES), (level, hitresult) -> new ReduxChestBoat(this, (Level)level, hitresult.m_82450_().f_82479_, hitresult.m_82450_().f_82480_, hitresult.m_82450_().f_82481_){}));
        this.signItem = ReduxItems.register(pWoodName + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16).m_41491_(AetherCreativeTabs.AETHER_BLOCKS), (Block)this.sign.get(), (Block)this.wallSign.get()));
        this.logWall = ReduxBlocks.register(this.woodName + "_" + pLogSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(barkColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
        this.woodWall = ReduxBlocks.register(this.woodName + "_" + pWoodSuffix + "_wall", () -> new ReduxNaturalWall(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(barkColor).m_60978_(2.0f).m_60918_(pLogSoundType)));
    }

    private RegistryObject<BlockEntityType<ReduxSignBlockEntity>> getSign() {
        return this.signEntity;
    }

    private RegistryObject<StandingSignBlock> getSignBlock() {
        return this.sign;
    }

    private RegistryObject<WallSignBlock> getWallSignBlock() {
        return this.wallSign;
    }
}

