/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.advancement.predicate;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class StatePredicate {
    public static final StatePredicate ANY = new StatePredicate(null, null, StatePropertiesPredicate.f_67658_);
    @Nullable
    private final TagKey<Block> tag;
    @Nullable
    private final Set<Block> blocks;
    private final StatePropertiesPredicate properties;

    public StatePredicate(@Nullable TagKey<Block> pTag, @Nullable Set<Block> pBlocks, StatePropertiesPredicate pProperties) {
        this.tag = pTag;
        this.blocks = pBlocks;
        this.properties = pProperties;
    }

    public boolean matches(BlockState blockstate) {
        if (this == ANY) {
            return true;
        }
        if (this.tag != null && !blockstate.m_204336_(this.tag)) {
            return false;
        }
        if (this.blocks != null && !this.blocks.contains(blockstate.m_60734_())) {
            return false;
        }
        return this.properties.m_67667_(blockstate);
    }

    public static StatePredicate fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"block");
            ImmutableSet set = null;
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"blocks", null);
            if (jsonarray != null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (JsonElement jsonelement : jsonarray) {
                    ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13805_((JsonElement)jsonelement, (String)"block"));
                    builder.add((Object)((Block)Registry.f_122824_.m_6612_(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown block id '" + resourcelocation + "'"))));
                }
                set = builder.build();
            }
            TagKey tagkey = null;
            if (jsonobject.has("tag")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"tag"));
                tagkey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)resourcelocation1);
            }
            StatePropertiesPredicate statepropertiespredicate = StatePropertiesPredicate.m_67679_((JsonElement)jsonobject.get("state"));
            return new StatePredicate(tagkey, (Set<Block>)set, statepropertiespredicate);
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (this.blocks != null) {
            JsonArray jsonarray = new JsonArray();
            for (Block block : this.blocks) {
                jsonarray.add(ForgeRegistries.BLOCKS.getKey((Object)block).toString());
            }
            jsonobject.add("blocks", (JsonElement)jsonarray);
        }
        if (this.tag != null) {
            jsonobject.addProperty("tag", this.tag.f_203868_().toString());
        }
        jsonobject.add("state", this.properties.m_67666_());
        return jsonobject;
    }

    public static class Builder {
        @Nullable
        private Set<Block> blocks;
        @Nullable
        private TagKey<Block> tag;
        private StatePropertiesPredicate properties = StatePropertiesPredicate.f_67658_;

        private Builder() {
        }

        public static Builder block() {
            return new Builder();
        }

        public Builder of(Block ... pBlocks) {
            this.blocks = ImmutableSet.copyOf((Object[])pBlocks);
            return this;
        }

        public Builder of(Iterable<Block> pBlocks) {
            this.blocks = ImmutableSet.copyOf(pBlocks);
            return this;
        }

        public Builder of(TagKey<Block> pTag) {
            this.tag = pTag;
            return this;
        }

        public Builder setProperties(StatePropertiesPredicate pProperties) {
            this.properties = pProperties;
            return this;
        }

        public StatePredicate build() {
            return new StatePredicate(this.tag, this.blocks, this.properties);
        }
    }
}

