/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.zepalesque.redux.misc.ReduxTags;

public class JellyshroomFeature
extends Feature<Config> {
    public JellyshroomFeature(Codec<Config> p_65975_) {
        super(p_65975_);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        int height = ((Config)context.m_159778_()).height.m_214085_(context.m_225041_());
        HashMap<BlockPos, BlockState> toPlace = new HashMap<BlockPos, BlockState>();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos origin = context.m_159777_();
        if (context.m_159774_().m_7433_(origin.m_7495_(), state -> !JellyshroomFeature.m_159759_((BlockState)state))) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            mutable.m_122154_((Vec3i)origin, 0, i, 0);
            BlockPos immutable1 = mutable.m_7949_();
            toPlace.putIfAbsent(immutable1, ((Config)context.m_159778_()).stem.m_213972_(context.m_225041_(), immutable1));
        }
        BlockPos jellyOrigin = origin.m_6630_(height);
        int radius = 2;
        for (int y = 0; y >= -3; --y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean isDiamond;
                    boolean center = y > -3 && y < 0;
                    boolean middlecorners = x != -radius && x != radius || z != -radius && z != radius;
                    boolean bl = isDiamond = Mth.m_14040_((int)x) + Mth.m_14040_((int)z) <= radius;
                    if ((!center || !middlecorners) && !isDiamond) continue;
                    mutable.m_122154_((Vec3i)jellyOrigin, x, y, z);
                    BlockPos immutable2 = mutable.m_7949_();
                    toPlace.putIfAbsent(immutable2, ((Config)context.m_159778_()).jelly.m_213972_(context.m_225041_(), immutable2));
                }
            }
        }
        if (height >= 7) {
            Direction d1 = Direction.Plane.HORIZONTAL.m_235690_(context.m_225041_());
            Direction d2 = (Direction)Util.m_214621_(Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> direction != d1).toList(), (RandomSource)context.m_225041_());
            int minAbove = 1;
            int max = height - 5;
            int h1 = context.m_225041_().m_188503_(max - minAbove) + minAbove;
            int h2 = context.m_225041_().m_188503_(max - minAbove) + minAbove;
            mutable.m_122154_((Vec3i)origin, d1.m_122429_(), h1, d1.m_122431_());
            BlockPos immutable3 = mutable.m_7949_();
            toPlace.putIfAbsent(immutable3, ((Config)context.m_159778_()).jelly.m_213972_(context.m_225041_(), immutable3));
            mutable.m_122154_((Vec3i)origin, d2.m_122429_(), h2, d2.m_122431_());
            BlockPos immutable4 = mutable.m_7949_();
            toPlace.putIfAbsent(immutable4, ((Config)context.m_159778_()).jelly.m_213972_(context.m_225041_(), immutable4));
        }
        for (Map.Entry entry : toPlace.entrySet()) {
            if (this.canPlaceBlockHere((LevelAccessor)context.m_159774_(), (BlockPos)entry.getKey())) continue;
            return false;
        }
        for (Map.Entry entry : toPlace.entrySet()) {
            this.m_5974_((LevelWriter)context.m_159774_(), (BlockPos)entry.getKey(), (BlockState)entry.getValue());
        }
        return true;
    }

    protected boolean canPlaceBlockHere(LevelAccessor level, BlockPos pos) {
        int i = pos.m_123342_();
        if (i >= level.m_141937_() + 1 && i + 1 < level.m_151558_()) {
            return level.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13106_) || state.m_60767_().m_76336_() || state.m_204336_(ReduxTags.Blocks.MUSHROOM_CAPS));
        }
        return false;
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(mushroom -> mushroom.group((App)BlockStateProvider.f_68747_.fieldOf("jelly_block").forGetter(config -> config.jelly), (App)BlockStateProvider.f_68747_.fieldOf("stem_block").forGetter(config -> config.stem), (App)IntProvider.f_146531_.fieldOf("height").forGetter(config -> config.height)).apply((Applicative)mushroom, Config::new));
        public final BlockStateProvider jelly;
        public final BlockStateProvider stem;
        public final IntProvider height;

        public Config(BlockStateProvider jelly, BlockStateProvider stem, IntProvider height) {
            this.jelly = jelly;
            this.stem = stem;
            this.height = height;
        }
    }
}

