/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.SyncAetherGrassesPacket;
import net.zepalesque.redux.world.biome.modifier.ReduxBiomeModifierCodecs;

public record AetherGrassColorModifier(HolderSet<Biome> biomes, int grass) implements BiomeModifier
{
    public static Map<ResourceLocation, Integer> AETHER_GRASS_COLORS_SERVER = new HashMap<ResourceLocation, Integer>();

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING && this.biomes.m_203333_(biome)) {
            Optional optional = biome.m_203543_();
            optional.ifPresent(key -> AETHER_GRASS_COLORS_SERVER.put(key.m_135782_(), this.grass));
        }
    }

    public static void sendToClient(ServerPlayer player) {
        ReduxPacketHandler.sendToPlayer(new SyncAetherGrassesPacket(AETHER_GRASS_COLORS_SERVER), player);
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ReduxBiomeModifierCodecs.AETHER_GRASS_COLOR.get();
    }
}

