/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util.level;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;

public class LevelUtil {
    public static boolean isBlockInAABB(AABB bb, Level world, Block block) {
        return LevelUtil.isBlockInAABB(bb, world, block, true);
    }

    public static boolean isBlockInAABB(AABB bb, Level world, Block block, boolean checkLoaded) {
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int minY = Mth.m_14107_((double)bb.f_82289_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxX = Mth.m_14165_((double)bb.f_82291_);
        int maxY = Mth.m_14165_((double)bb.f_82292_);
        int maxZ = Mth.m_14165_((double)bb.f_82293_);
        if (checkLoaded && !world.m_46832_(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ))) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        LevelChunk chunk = null;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                if (chunk != null && (chunk.m_7697_().f_45578_ != x >> 4 || chunk.m_7697_().f_45579_ != z >> 4)) {
                    chunk = null;
                }
                if (chunk == null) {
                    chunk = world.m_6325_(x >> 4, z >> 4);
                }
                for (int y = minY; y < maxY; ++y) {
                    pos.m_122178_(x, y, z);
                    if (world.m_8055_((BlockPos)pos).m_60734_() != block) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isTagInAABB(AABB bb, Level world, TagKey<Block> tag, boolean checkLoaded) {
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int minY = Mth.m_14107_((double)bb.f_82289_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxX = Mth.m_14165_((double)bb.f_82291_);
        int maxY = Mth.m_14165_((double)bb.f_82292_);
        int maxZ = Mth.m_14165_((double)bb.f_82293_);
        if (checkLoaded && !world.m_46832_(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ))) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        LevelChunk chunk = null;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                if (chunk != null && (chunk.m_7697_().f_45578_ != x >> 4 || chunk.m_7697_().f_45579_ != z >> 4)) {
                    chunk = null;
                }
                if (chunk == null) {
                    chunk = world.m_6325_(x >> 4, z >> 4);
                }
                for (int y = minY; y < maxY; ++y) {
                    pos.m_122178_(x, y, z);
                    if (!world.m_8055_((BlockPos)pos).m_204336_(tag)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isTagInAABB1(AABB bb, Level world, TagKey<Block> tag) {
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int minY = Mth.m_14107_((double)bb.f_82289_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxX = Mth.m_14165_((double)bb.f_82291_);
        int maxY = Mth.m_14165_((double)bb.f_82292_);
        int maxZ = Mth.m_14165_((double)bb.f_82293_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    pos.m_122178_(x, y, z);
                    if (!world.m_8055_((BlockPos)pos).m_204336_(tag)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCollectionInAABB(AABB bb, Level level, Collection<Block> collection) {
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int minY = Mth.m_14107_((double)bb.f_82289_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxX = Mth.m_14165_((double)bb.f_82291_);
        int maxY = Mth.m_14165_((double)bb.f_82292_);
        int maxZ = Mth.m_14165_((double)bb.f_82293_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    pos.m_122178_(x, y, z);
                    if (!collection.contains(level.m_8055_((BlockPos)pos).m_60734_())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

