/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.recipe;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.zepalesque.redux.item.util.VeridiumItem;
import net.zepalesque.redux.recipe.StackingRecipe;

public abstract class AbstractStackingRecipe
implements StackingRecipe {
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int infusionAmount;

    public AbstractStackingRecipe(RecipeType<?> type, ResourceLocation id, Ingredient ingredient, ItemStack result, int infusionAmount) {
        this.type = type;
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.infusionAmount = infusionAmount;
    }

    public boolean matches(Level level, ItemStack item) {
        return this.getIngredient().test(item);
    }

    @Override
    @Nullable
    public ItemStack getResultStack(ItemStack originalStack) {
        if (!this.getIngredient().test(originalStack)) {
            return null;
        }
        ItemStack resultStack = this.getResult();
        resultStack.m_41751_(originalStack.m_41783_());
        ItemStack i = VeridiumItem.infuse(resultStack, this.infusionAmount);
        resultStack.m_41764_(originalStack.m_41613_());
        return i;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int infusionAmount() {
        return this.infusionAmount;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }
}

