/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.mixin.client.block;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.natural.AetherDoubleDropsLeaves;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.natural.ExtendedDistanceLeavesBlock;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.misc.ReduxTags;
import net.zepalesque.redux.mixin.client.block.LeafBlockClientMixin;
import net.zepalesque.redux.util.compat.DeepCompatUtil;
import net.zepalesque.redux.util.level.ParticlePlacementUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AetherDoubleDropsLeaves.class})
public class AetherLeavesClientMixin
extends LeafBlockClientMixin {
    @Unique
    private static final Lazy<Map<Block, Supplier<? extends ParticleOptions>>> PARTICLE_MAP = Lazy.of(() -> new ImmutableMap.Builder().put((Object)((Block)AetherBlocks.SKYROOT_LEAVES.get()), ReduxParticleTypes.FALLING_SKYROOT_LEAVES).put((Object)((Block)ReduxBlocks.BLIGHTWILLOW_LEAVES.get()), ReduxParticleTypes.FALLING_BLIGHTWILLOW_LEAVES).put((Object)((Block)ReduxBlocks.BLIGHTED_SKYROOT_LEAVES.get()), ReduxParticleTypes.FALLING_BLIGHTED_SKYROOT_LEAVES).build());

    @Override
    protected void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        BlockPos blockpos;
        BlockState blockstate;
        int chance;
        super.animateTick(state, level, pos, random, ci);
        @Nullable Supplier<? extends ParticleOptions> supplier = AetherLeavesClientMixin.redux$getParticle((Block)((AetherDoubleDropsLeaves)this));
        int n = chance = level.m_204166_(pos).m_203656_(ReduxTags.Biomes.DENSE_LEAF_FALL) ? 20 : 30;
        if (!(supplier == null || random.m_188503_(chance) != 0 || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP) || blockstate.m_60734_() instanceof LeavesBlock || blockstate.m_60734_() instanceof ExtendedDistanceLeavesBlock)) {
            ParticlePlacementUtil.spawnParticleBelow(level, pos, random, supplier.get());
        }
    }

    @Unique
    @Nullable
    private static Supplier<? extends ParticleOptions> redux$getParticle(Block self) {
        if (((Boolean)ReduxConfig.CLIENT.better_leaf_particles.get()).booleanValue()) {
            Supplier<? extends ParticleOptions> deep;
            @Nullable Supplier<? extends ParticleOptions> particle = (Supplier<? extends ParticleOptions>)((Map)PARTICLE_MAP.get()).get(self);
            if (particle == null && Redux.deepAetherCompat() && (deep = DeepCompatUtil.getParticle(self)) != null) {
                particle = deep;
            }
            return particle;
        }
        return null;
    }
}

