/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.event.listener;

import com.aetherteam.aether.entity.monster.Cockatrice;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.item.EquipmentUtil;
import java.util.Optional;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zepalesque.redux.capability.living.VampireAmulet;
import net.zepalesque.redux.capability.player.ReduxPlayer;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.QuicksoilSetting;
import net.zepalesque.redux.effect.ReduxEffects;
import net.zepalesque.redux.event.hook.MobHooks;
import net.zepalesque.redux.event.hook.SwetHooks;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.misc.ReduxTags;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="aether_redux")
public class MobListener {
    @SubscribeEvent
    public static void modifyAI(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Cockatrice) {
            Cockatrice cockatrice = (Cockatrice)entity;
            if (((Boolean)ReduxConfig.COMMON.improved_cockatrice_behavior.get()).booleanValue()) {
                MobHooks.modifyCockatriceAI(cockatrice);
            }
        }
        if ((entity = event.getEntity()) instanceof Swet) {
            Swet swet = (Swet)entity;
            if (((Boolean)ReduxConfig.COMMON.pl_swet_behavior.get()).booleanValue()) {
                SwetHooks.modifySwetAI(swet);
            }
        }
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        @Nullable Player plr = null;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player ent;
            plr = ent = (Player)entity;
        }
        if ((entity = event.getSource().m_7640_()) instanceof Player) {
            Player dir;
            plr = dir = (Player)entity;
        }
        if (plr != null) {
            EntityType type = event.getEntity().m_6095_();
            ReduxPlayer.get(plr).ifPresent(reduxPlayer -> reduxPlayer.getLoreModule().incrementEntity(type));
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        MobHooks.updateCapabilities(entity);
        if (entity instanceof Swet) {
            Swet swet = (Swet)entity;
            SwetHooks.swetTick(swet);
        }
        double d0 = Math.abs(entity.m_20185_() - entity.f_19790_);
        double d1 = Math.abs(entity.m_20189_() - entity.f_19792_);
        if ((d0 >= (double)0.003f || d1 >= (double)0.003f) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.f_19853_.m_5776_()) {
                Optional b = player.f_19853_.m_204166_(player.m_20183_()).m_203543_();
                b.ifPresent(biomeResourceKey -> ReduxPlayer.get(player).ifPresent(reduxPlayer -> reduxPlayer.getLoreModule().incrementBiome(biomeResourceKey.m_135782_())));
            }
        }
    }

    @SubscribeEvent
    public static void attack(LivingHurtEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity && EquipmentUtil.hasCurio((LivingEntity)(entity = (LivingEntity)entity2), (Item)((Item)ReduxItems.VAMPIRE_AMULET.get()))) {
            VampireAmulet.get(entity).ifPresent(vampireAmulet -> {
                if (vampireAmulet.canUseAbility() && !vampireAmulet.getMob().f_19853_.m_46461_()) {
                    float life = MobListener.getLifeSteal(event.getAmount());
                    vampireAmulet.getMob().m_5634_(life);
                }
            });
        }
        if (EquipmentUtil.hasCurio((LivingEntity)event.getEntity(), (Item)((Item)ReduxItems.VAMPIRE_AMULET.get())) && event.getEntity().f_19853_.m_46461_()) {
            float hurt = event.getAmount() * 1.25f;
            event.setAmount(hurt);
        }
    }

    @SubscribeEvent
    public static void adrenalineDeplete(MobEffectEvent.Expired event) {
        if (event.getEffectInstance().m_19544_() == ReduxEffects.ADRENALINE_RUSH.get()) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ReduxEffects.ADRENAL_FATIGUE.get(), 600, 1, false, false, true));
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ReduxPlayer.get(player).ifPresent(redux -> redux.getAdrenalineModule().beginCooldown());
            }
        }
    }

    private static float getLifeSteal(float damage) {
        return (damage <= 0.0f ? 0.0f : (damage <= 20.0f ? 0.5f * damage - 0.01f * damage * damage : damage * 0.1f + 4.0f)) * 0.5f;
    }

    @SubscribeEvent
    public static void movementHandling(LivingEvent.LivingTickEvent event) {
        if (ReduxConfig.COMMON.quicksoil_movement_system.get() == QuicksoilSetting.highlands) {
            Player player;
            LivingEntity entity = event.getEntity();
            if (!entity.m_20096_()) {
                return;
            }
            if (entity.m_20069_()) {
                return;
            }
            if (Math.abs(entity.m_20184_().f_82479_ + entity.m_20184_().f_82480_ + entity.m_20184_().f_82481_) < 0.001) {
                return;
            }
            if (entity instanceof Player && (player = (Player)entity).m_5833_()) {
                return;
            }
            if (entity.f_19853_.m_8055_(entity.m_20099_()).m_204336_(ReduxTags.Blocks.QUICKSOIL_BEHAVIOR)) {
                MobHooks.modifyEntityQuicksoil(entity);
            }
        }
    }
}

