/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.event.hook;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.loot.AetherLootContexts;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.loot.ReduxLoot;

public class ToolModifHooks {
    public static final Map<Block, Block> STRIPPABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().build());
    public static final Map<Block, Block> FLATTENABLES;
    public static final Map<Block, Block> TILLABLES;

    public static BlockState setupToolActions(LevelAccessor accessor, BlockPos pos, BlockState old, ToolAction action) {
        Block oldBlock = old.m_60734_();
        if (action == ToolActions.AXE_STRIP) {
            if (STRIPPABLES.containsKey(oldBlock)) {
                return STRIPPABLES.get(oldBlock).m_152465_(old);
            }
        } else if (action == ToolActions.SHOVEL_FLATTEN) {
            if (FLATTENABLES.containsKey(oldBlock)) {
                return FLATTENABLES.get(oldBlock).m_152465_(old);
            }
        } else if (action == ToolActions.HOE_TILL && accessor.m_8055_(pos.m_7494_()).m_60795_() && TILLABLES.containsKey(oldBlock)) {
            return TILLABLES.get(oldBlock).m_152465_(old);
        }
        return old;
    }

    public static void stripBlightwillow(LevelAccessor accessor, BlockState state, ItemStack stack, ToolAction action, UseOnContext context) {
        if (action == ToolActions.AXE_STRIP && accessor instanceof Level) {
            Level level = (Level)accessor;
            if (Redux.WoodHandlers.BLIGHTWILLOW.sporingBlocksBlockTag.isPresent() && state.m_204336_(Redux.WoodHandlers.BLIGHTWILLOW.sporingBlocksBlockTag.get()) && stack.m_204117_(AetherTags.Items.GOLDEN_AMBER_HARVESTERS) && level.m_7654_() != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 vector = context.m_43720_();
                LootContext.Builder lootContext = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81463_, (Object)stack);
                LootTable lootTable = level.m_7654_().m_129898_().m_79217_(ReduxLoot.STRIP_BLIGHTWILLOW);
                ObjectArrayList list = lootTable.m_230922_(lootContext.m_78975_(AetherLootContexts.STRIPPING));
                for (ItemStack itemStack : list) {
                    ItemEntity itemEntity = new ItemEntity(level, vector.m_7096_(), vector.m_7098_(), vector.m_7094_(), itemStack);
                    itemEntity.m_32060_();
                    level.m_7967_((Entity)itemEntity);
                }
            }
        }
    }

    static {
        for (WoodHandler woodHandler : Redux.WoodHandlers.WOOD_HANDLERS) {
            if (!woodHandler.hasStrippedLogs) continue;
            STRIPPABLES.put((Block)woodHandler.log.get(), (Block)woodHandler.strippedLog.get().get());
            STRIPPABLES.put((Block)woodHandler.wood.get(), (Block)woodHandler.strippedWood.get().get());
            STRIPPABLES.put((Block)woodHandler.logWall.get(), (Block)woodHandler.strippedLogWall.get().get());
            STRIPPABLES.put((Block)woodHandler.woodWall.get(), (Block)woodHandler.strippedWoodWall.get().get());
            woodHandler.sporingLog.ifPresent(log -> STRIPPABLES.put((Block)log.get(), (Block)woodHandler.strippedLog.get().get()));
            woodHandler.sporingWood.ifPresent(wood -> STRIPPABLES.put((Block)wood.get(), (Block)woodHandler.strippedWood.get().get()));
        }
        FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)((Block)ReduxBlocks.AVELIUM.get()), (Object)((Block)AetherBlocks.AETHER_DIRT_PATH.get())).build());
        TILLABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)((Block)ReduxBlocks.AVELIUM.get()), (Object)((Block)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((Block)ReduxBlocks.COARSE_AETHER_DIRT.get()), (Object)((Block)AetherBlocks.AETHER_DIRT.get())).build());
    }
}

