/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.geo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.entity.passive.Mykapod;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class MykapodRenderer
extends GeoEntityRenderer<Mykapod> {
    public MykapodRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new MykapodModel());
    }

    public ResourceLocation getTextureLocation(Mykapod mykapod) {
        return mykapod.hasShell() && !mykapod.m_6162_() ? MykapodModel.TEXTURE_LOCATION : MykapodModel.DESHELLED_LOCATION;
    }

    public void render(Mykapod entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!Minecraft.m_91087_().m_91104_()) {
            if (entity.getHurtAngle() != 0.0f) {
                poseStack.m_85845_(new Vector3f(entity.getHurtAngleX(), 0.0f, -entity.getHurtAngleZ()).m_122240_(entity.getHurtAngle() * -15.0f));
            }
            if ((double)entity.getHurtAngle() > 0.0) {
                entity.setHurtAngle(Mth.m_14179_((float)partialTick, (float)entity.getHurtAngle(), (float)(entity.getHurtAngle() * 0.78f)));
            }
            if (LivingEntityRenderer.m_194453_((LivingEntity)entity)) {
                poseStack.m_85837_(0.0, (double)(entity.m_20206_() + 0.1f), 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            }
        }
        if (entity.m_6162_()) {
            float babyScale = 0.5f;
            poseStack.m_85841_(babyScale, babyScale, babyScale);
        }
        super.render((LivingEntity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public RenderType getRenderType(Mykapod animatable, float partialTick, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.001f;
    }

    public static class MykapodModel
    extends AnimatedGeoModel<Mykapod> {
        private static final ResourceLocation TEXTURE_LOCATION = Redux.locate("textures/entity/mobs/mykapod/mykapod.png");
        private static final ResourceLocation DESHELLED_LOCATION = Redux.locate("textures/entity/mobs/mykapod/mykapod_shed.png");
        private static final ResourceLocation GEO_LOCATION = Redux.locate("geo/mykapod.geo.json");
        private static final ResourceLocation ANIM_LOCATION = Redux.locate("animations/mykapod.animation.json");

        public ResourceLocation getModelResource(Mykapod mykapod) {
            return GEO_LOCATION;
        }

        public ResourceLocation getTextureResource(Mykapod mykapod) {
            return mykapod.hasShell() && !mykapod.m_6162_() ? TEXTURE_LOCATION : DESHELLED_LOCATION;
        }

        public ResourceLocation getAnimationResource(Mykapod mykapod) {
            return ANIM_LOCATION;
        }

        public void setCustomAnimations(Mykapod animatable, int instanceId, AnimationEvent animationState) {
            super.setCustomAnimations((IAnimatable)animatable, instanceId, animationState);
        }
    }
}

